/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jetcd.JetcdContext;
import com.lubanops.apm.plugin.jetcd.JetcdUtils;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.JetcdWatcherSampleFilter;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.api.WatchResponse;
import java.util.List;

public class WatcherImplOnStreamInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                Object[] attributes = ((AttributeAccess)object).getLopsFileds();
                Watch.Listener listener = (Watch.Listener)attributes[2];
                String url = listener.getClass().getName() + "#" + methodName;
                JetcdCollector.onWatcherStart(url);
                SpanEvent preSpanEvent = TraceCollector.getSpanEvent();
                if (preSpanEvent != null) {
                    JetcdContext.SAVED_SPANEVENT_LOCAL.set(preSpanEvent);
                }
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, null, null, null);
                startTraceRequest.setRealSource(url);
                startTraceRequest.setSource(url);
                startTraceRequest.setKind("Jetcd");
                startTraceRequest.setSampleFilter((SampleFilter)new JetcdWatcherSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                if (args.length >= 1 && args[0] instanceof WatchResponse) {
                    WatcherImplOnStreamInterceptor.addTag4WatchResponse((WatchResponse)args[0], spanEvent);
                }
            }
        }
        catch (Exception watcherImplOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)watcherImplOnStreamException);
        }
        return new Object[0];
    }

    private static void addTag4WatchResponse(WatchResponse response, SpanEvent spanEvent) {
        if (response != null && spanEvent != null) {
            long watchId = response.getWatchId();
            boolean created = response.getCreated();
            boolean canceled = response.getCanceled();
            long compactRevision = response.getCompactRevision();
            String cancelReason = JetcdUtils.getTruncatedTag(response.getCancelReason());
            List eventsList = response.getEventsList();
            spanEvent.addTag("watch_id", String.valueOf(watchId));
            if (created) {
                spanEvent.addTag("created", String.valueOf(true));
            }
            if (canceled) {
                spanEvent.addTag("cancelled", String.valueOf(true));
                spanEvent.addTag("cancelled reason", cancelReason);
                spanEvent.addTag("compact_revision", String.valueOf(compactRevision));
                spanEvent.addTag("events", JetcdUtils.getEventsAsTag(eventsList));
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                JetcdCollector.onException(e);
                JetcdContext.HAS_ERROR_LOCAL.set(Boolean.TRUE);
            }
        }
        catch (Exception watcherImplOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)watcherImplOnStreamException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                boolean isSuccess = !Boolean.TRUE.equals(JetcdContext.HAS_ERROR_LOCAL.get());
                JetcdCollector.onWatcherFinally();
                TraceCollector.onFinally((int)(isSuccess ? 200 : 500));
                if (JetcdContext.SAVED_SPANEVENT_LOCAL.get() != null) {
                    TraceCollector.setSpanEvent((SpanEvent)JetcdContext.SAVED_SPANEVENT_LOCAL.get());
                }
                JetcdContext.SAVED_SPANEVENT_LOCAL.remove();
                JetcdContext.HAS_ERROR_LOCAL.remove();
            }
        }
        catch (Exception watcherImplOnStreamException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)watcherImplOnStreamException);
        }
    }
}

