/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.jetcd.JetcdConfig;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.api.Event;
import io.etcd.jetcd.api.KeyValue;
import io.etcd.jetcd.api.LeaderKey;
import io.etcd.jetcd.options.WatchOption;
import java.net.URI;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class JetcdUtils {
    public static String getLeaderKeyAsTag(LeaderKey leaderKey) {
        String name = leaderKey.getName().toStringUtf8();
        String key = leaderKey.getKey().toStringUtf8();
        long rev = leaderKey.getRev();
        long lease = leaderKey.getLease();
        return JetcdUtils.getTruncatedTag("name=" + name + ";" + "key" + "=" + key + ";" + "rev" + "=" + rev + ";" + "lease" + "=" + lease);
    }

    public static String getWatchCreateRequestAsTag(ByteSequence keySeq, WatchOption option) {
        StringBuilder sb = new StringBuilder();
        String key = keySeq.toString();
        sb.append("key=").append(key).append(";");
        Optional endKeyOption = option.getEndKey();
        long revision = option.getRevision();
        if (endKeyOption.isPresent()) {
            sb.append("range_end=").append(((ByteSequence)endKeyOption.get()).toString()).append(";");
        }
        sb.append("start_revision=").append(revision);
        return JetcdUtils.getTruncatedTag(sb.toString());
    }

    public static String getWatchCancelRequestAsTag(long id) {
        return JetcdUtils.getTruncatedTag("watch_id=" + id);
    }

    public static String getEncryptedValIfSet(String val) {
        return JetcdConfig.isParseValue() ? val : "?";
    }

    public static String getTruncatedTag(String oriStr) {
        if (oriStr == null) {
            return null;
        }
        int tagMaxLength = JetcdConfig.getTagMaxLength();
        String res = oriStr.length() > tagMaxLength ? oriStr.substring(0, tagMaxLength) + "..." : oriStr;
        return res;
    }

    public static String getTruncatedTag(StringBuilder oriSb) {
        if (oriSb == null) {
            return null;
        }
        int tagMaxLength = JetcdConfig.getTagMaxLength();
        if (oriSb.length() > tagMaxLength) {
            oriSb.setLength(tagMaxLength);
        }
        return oriSb.toString();
    }

    public static String getEtcdEndpoints(Object builder) {
        StringBuilder sb = new StringBuilder();
        if (builder instanceof AttributeAccess) {
            Object[] attributes = ((AttributeAccess)builder).getLopsFileds();
            Collection endpoints = (Collection)attributes[0];
            if (endpoints != null) {
                for (URI endpoint : endpoints) {
                    String hostPort = endpoint.getHost() + ":" + endpoint.getPort();
                    if (sb.length() == 0) {
                        sb.append(hostPort);
                        continue;
                    }
                    sb.append(",").append(hostPort);
                }
            } else {
                String target = (String)attributes[1];
                if (target != null) {
                    return target;
                }
            }
        }
        return sb.toString();
    }

    public static String getKvAsTag(KeyValue keyValue) {
        boolean parseValue = JetcdConfig.isParseValue();
        StringBuilder sb = new StringBuilder();
        String key = keyValue.getKey().toStringUtf8();
        String value = parseValue ? keyValue.getValue().toStringUtf8() : "?";
        long lease = keyValue.getLease();
        String toAppend = "key=" + key + "," + "value" + "=" + value + "," + "lease" + "=" + lease;
        sb.append(toAppend);
        return JetcdUtils.getTruncatedTag(sb);
    }

    public static String getKvsAsTag(List<KeyValue> kvList) {
        int tagMaxLength = JetcdConfig.getTagMaxLength();
        boolean parseValue = JetcdConfig.isParseValue();
        StringBuilder sb = new StringBuilder();
        for (KeyValue keyValue : kvList) {
            String key = keyValue.getKey().toStringUtf8();
            String value = parseValue ? keyValue.getValue().toStringUtf8() : "?";
            long lease = keyValue.getLease();
            String toAppend = "key=" + key + "," + "value" + "=" + value + "," + "lease" + "=" + lease;
            if (sb.length() == 0) {
                sb.append(toAppend);
            } else {
                sb.append(";").append(toAppend);
            }
            if (sb.length() <= tagMaxLength) continue;
            sb.setLength(tagMaxLength);
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    public static String getEventsAsTag(List<Event> eventList) {
        int tagMaxLength = JetcdConfig.getTagMaxLength();
        boolean parseValue = JetcdConfig.isParseValue();
        StringBuilder sb = new StringBuilder();
        sb.append("Events:[");
        for (Event event : eventList) {
            String type = event.getType().name();
            KeyValue prevKv = event.getPrevKv();
            KeyValue kv = event.getKv();
            sb.append("{");
            sb.append("type").append(":").append(type).append(";");
            sb.append("prev_kv").append(":").append("key").append("=").append(prevKv.getKey().toStringUtf8()).append(",").append("value").append("=").append(parseValue ? prevKv.getValue().toStringUtf8() : "?").append(";");
            sb.append("kv").append(":").append("key").append("=").append(kv.getKey().toStringUtf8()).append(",").append("value").append("=").append(parseValue ? kv.getValue().toStringUtf8() : "?");
            sb.append("}");
            if (sb.length() <= tagMaxLength) continue;
            sb.setLength(tagMaxLength);
            sb.append("...");
            break;
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        try {
            JetcdCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)Client.class.getProtectionDomain()));
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "Unknown Etcd version", (Throwable)e);
            JetcdCollector.setDriverVersion("unknown");
        }
    }
}

