/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.dubbo.collector.DubboThreadPoolStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboThreadPoolAggregator
extends AbstractAggregator {
    private static final int MAX_SIZE = 8;
    private static final String DUBBO_AGGREGATE_KEY_POOL_ID = "poolId";
    private ConcurrentMap<String, DubboThreadPoolStats> valueStats = new ConcurrentHashMap<String, DubboThreadPoolStats>(16);

    public String getName() {
        return "threadPool";
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public void register(String poolId, ThreadPoolExecutor pool, String poolType) {
        if (this.valueStats.size() < 8) {
            this.valueStats.putIfAbsent(poolId, new DubboThreadPoolStats());
            ((DubboThreadPoolStats)this.valueStats.get(poolId)).bind(pool, poolType);
        }
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        MonitorDataRow dataRow = null;
        String poolId = primaryKeyMap.get(DUBBO_AGGREGATE_KEY_POOL_ID);
        if (StringUtils.isBlank((String)poolId)) {
            return dataRow;
        }
        DubboThreadPoolStats poolStats = (DubboThreadPoolStats)this.valueStats.get(poolId);
        return poolStats.harvest();
    }

    public List<MonitorDataRow> getAllStatus() {
        return this.harvest();
    }

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> poolList = new ArrayList<MonitorDataRow>();
        for (Map.Entry entry : this.valueStats.entrySet()) {
            MonitorDataRow dataRow = ((DubboThreadPoolStats)entry.getValue()).harvest();
            dataRow.put((Object)DUBBO_AGGREGATE_KEY_POOL_ID, entry.getKey());
            poolList.add(dataRow);
        }
        return poolList;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void clear() {
        this.setFull(false);
        this.setFullOutputted(false);
    }
}

