/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.cassandra3.apreload.CassandraStats;
import java.util.HashMap;
import java.util.Map;

public class CassandraConnectionAggregator
extends SinglePrimaryKeyAggregator<CassandraStats> {
    private int timeSpanThreshold = 1;
    private static final String TIME_SPAN_THRESHOLD = "CassandraConnectionTimeSpanThreshold";

    public void parseParameters(Map<String, String> parameters) {
        Integer curTimeSpanThreshold = ParameterParseUtil.getInteger(parameters, (String)TIME_SPAN_THRESHOLD);
        if (curTimeSpanThreshold != null) {
            this.timeSpanThreshold = curTimeSpanThreshold;
        }
    }

    public Map<String, Object> onStartAsync(String host) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        CassandraStats stats = (CassandraStats)this.getValue(host);
        if (stats != null) {
            map.put("startTime", stats.onStart());
            map.put("stats", (Object)stats);
        }
        return map;
    }

    public void onErrorAsync(CassandraStats stats, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null) {
            stats.onError(traceId);
        }
    }

    public void onFinallyAsync(Long startTime, CassandraStats stats, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(traceId);
        }
    }

    public int getTimeSpanThreshold() {
        return this.timeSpanThreshold;
    }

    protected Class<CassandraStats> getValueType() {
        return CassandraStats.class;
    }

    public String getName() {
        return "connection";
    }

    protected String primaryKey() {
        return "host";
    }
}

