/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.utils.SqlParserUtil;
import com.lubanops.apm.plugin.cassandra3.CassandraStatsConfig;
import java.net.InetSocketAddress;
import java.util.Set;

public class CassandraUtils {
    public static String getOriginalCqlQueryTruncated(Statement statement) {
        String query = null;
        if (statement instanceof BoundStatement) {
            query = ((BoundStatement)statement).preparedStatement().getQueryString();
        } else if (statement instanceof RegularStatement) {
            query = ((RegularStatement)statement).getQueryString();
        }
        if (query != null) {
            int cqlSize = CassandraStatsConfig.getCqlSize();
            if (query.length() > cqlSize) {
                query = query.substring(0, cqlSize);
            }
        }
        return query;
    }

    public static String getParsedCqlQuery(String cqlQuery) {
        return SqlParserUtil.parse((String)cqlQuery);
    }

    public static int getFetchedCount(ResultSet resultSet) {
        int count = 0;
        if (resultSet != null) {
            count = resultSet.getAvailableWithoutFetching();
        }
        return count;
    }

    public static String getConnectionAddress(Object connection) {
        String address = "Unknown";
        if (connection instanceof AttributeAccess) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)((AttributeAccess)connection).getLopsFileds()[0];
            address = CassandraUtils.withPrefixSlashRemoved(inetSocketAddress.toString());
        }
        return address;
    }

    public static String getClusterHosts(Cluster cluster) {
        Metadata metadata = cluster.getMetadata();
        Set hosts = metadata.getAllHosts();
        StringBuilder sb = new StringBuilder();
        for (Host host : hosts) {
            String hostAsString = CassandraUtils.withPrefixSlashRemoved(host.toString());
            if (sb.length() == 0) {
                sb.append(hostAsString);
                continue;
            }
            sb.append(",").append(hostAsString);
        }
        return sb.toString();
    }

    public static String withPrefixSlashRemoved(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }
}

