/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mariadb.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import java.security.ProtectionDomain;
import org.mariadb.jdbc.MariaDbConnection;

public class MysqlConnectionInterceptor
implements Interceptor {
    public MysqlConnectionInterceptor() {
        MysqlCollector.setDriverVersion((String)Util.getJarVersionFromProtectionDomain((ProtectionDomain)MariaDbConnection.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object thisObject, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            MariaDbConnection connection = (MariaDbConnection)object;
            String dbName = Helper.getDbName((String)connection.getHostname(), (int)connection.getPort(), (String)connection.getCatalog());
            Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(dbName);
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setLopsAttribute((Object)id);
            }
            MysqlCollector.onConnectionCreated((Integer)id);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }
}

