/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector.config;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.ExcludePattern;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlPattern;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class UrlStatsConfig {
    public static final int DEFAULT_BIZCODE_LENGTH = 0;
    private static boolean bodyDetail = AgentConfigManager.isCollectBody();
    private static boolean isGzip = false;
    private static int bodyLength = AgentConfigManager.getCollectBodyLength();
    private static String[] headerKeys = new String[0];
    private static String[] parameterKeys = new String[0];
    private static String[] cookieKeys = new String[0];
    private static List<UrlPattern> urlList = new ArrayList<UrlPattern>();
    private static List<ExcludePattern> excludeUrlList = new ArrayList<ExcludePattern>();
    private static int bizCodeLength = 0;
    private static String[] bizCodeFields = new String[0];
    private static Set<String> bizCodeRightValues = new HashSet<String>();
    private static List<String> bizCodeRightValuePatterns = new ArrayList<String>();
    private static Set<String> springUrlList = new ConcurrentSkipListSet<String>(new URLComparator());
    private static Map<String, String> cf2Router = new HashMap<String, String>();

    private static int processResult(Integer o1Index, Integer o2Index, Integer o1length, Integer o2length) {
        if (o1Index == 0 && o2Index != 0) {
            return -1;
        }
        if (o2Index == 0 && o1Index != 0) {
            return 1;
        }
        if (o2Index == 0 && o1Index == 0) {
            return 0;
        }
        if (o1length > o2length) {
            return -1;
        }
        if (o1length < o2length) {
            return 1;
        }
        if (o1Index < o2Index) {
            return -1;
        }
        if (o1Index > o2Index) {
            return 1;
        }
        return 0;
    }

    public static void setBodyDetail(Boolean bodyDetail) {
        UrlStatsConfig.bodyDetail = bodyDetail == null ? AgentConfigManager.isCollectBody() : bodyDetail;
    }

    public static void setIsGzip(Boolean isGzip) {
        if (isGzip == null) {
            UrlStatsConfig.setGzip(false);
        } else {
            UrlStatsConfig.setGzip(isGzip);
        }
    }

    public static void setBodyLength(Integer bodyLength) {
        UrlStatsConfig.bodyLength = bodyLength == null || bodyLength < 0 ? AgentConfigManager.getCollectBodyLength() : bodyLength;
    }

    public static void setBizCodeLength(Integer bizCodeLength) {
        UrlStatsConfig.bizCodeLength = bizCodeLength == null || bizCodeLength < 0 ? 0 : bizCodeLength;
    }

    public static void setBizCodeFields(String[] bizCodeFields) {
        UrlStatsConfig.bizCodeFields = bizCodeFields == null ? new String[0] : (String[])bizCodeFields.clone();
    }

    public static void setBizCodeRightValues(String[] bizCodeRightValues) {
        if (bizCodeRightValues == null) {
            UrlStatsConfig.bizCodeRightValues = new HashSet<String>();
            UrlStatsConfig.setBizCodeRightValuePatterns(new ArrayList<String>());
        } else {
            HashSet<String> set = new HashSet<String>();
            ArrayList<String> list = new ArrayList<String>();
            for (String bizCodeRightValue : bizCodeRightValues) {
                if (bizCodeRightValue.startsWith("startsWith(") && bizCodeRightValue.endsWith(")")) {
                    list.add(bizCodeRightValue.substring(11, bizCodeRightValue.length() - 1));
                    continue;
                }
                set.add(bizCodeRightValue);
            }
            UrlStatsConfig.setBizCodeRightValuePatterns(list);
            UrlStatsConfig.bizCodeRightValues = set;
        }
    }

    public static void setHeaderKeys(String[] headerKeys) {
        UrlStatsConfig.headerKeys = headerKeys == null ? new String[0] : (String[])headerKeys.clone();
    }

    public static void setParameterKeys(String[] parameterKeys) {
        UrlStatsConfig.parameterKeys = parameterKeys == null ? new String[0] : (String[])parameterKeys.clone();
    }

    public static void setCookieKeys(String[] cookieKeys) {
        UrlStatsConfig.cookieKeys = cookieKeys == null ? new String[0] : (String[])cookieKeys.clone();
    }

    public static void setUrlList(List<UrlPattern> patternArray) {
        urlList = patternArray != null ? patternArray : new ArrayList<UrlPattern>();
    }

    public static void setExcludeUrlList(List<ExcludePattern> excludeArray) {
        excludeUrlList = excludeArray != null ? excludeArray : new ArrayList<ExcludePattern>();
    }

    public static void addUrl(String url) {
        if (url != null) {
            springUrlList.add(url);
        }
    }

    public static ConcurrentSkipListSet newUrlList() {
        return new ConcurrentSkipListSet<String>(new URLComparator());
    }

    public static Set<String> getSpringUrlList() {
        return springUrlList;
    }

    public static void setSpringUrlList(Set<String> springUrlSet) {
        springUrlList = springUrlSet;
    }

    public static void addUrl(Set<String> set) {
        for (String url : set) {
            if (url == null) continue;
            springUrlList.add(url);
        }
    }

    public static String[] getBizCodeFields() {
        return (String[])bizCodeFields.clone();
    }

    public static String[] getCookieKeys() {
        return (String[])cookieKeys.clone();
    }

    public static String[] getHeaderKeys() {
        return (String[])headerKeys.clone();
    }

    public static String[] getParameterKeys() {
        return (String[])parameterKeys.clone();
    }

    public static int getBizCodeLength() {
        return bizCodeLength;
    }

    public static void setBizCodeLength(int bizCodeLength) {
        UrlStatsConfig.bizCodeLength = bizCodeLength;
    }

    public static boolean isBodyDetail() {
        return bodyDetail;
    }

    public static void setBodyDetail(boolean bodyDetail) {
        UrlStatsConfig.bodyDetail = bodyDetail;
    }

    public static int getBodyLength() {
        return bodyLength;
    }

    public static void setBodyLength(int bodyLength) {
        UrlStatsConfig.bodyLength = bodyLength;
    }

    public static List<ExcludePattern> getExcludeUrlList() {
        return excludeUrlList;
    }

    public static boolean isGzip() {
        return isGzip;
    }

    public static void setGzip(boolean isGzip) {
        UrlStatsConfig.isGzip = isGzip;
    }

    public static List<UrlPattern> getUrlList() {
        return urlList;
    }

    public static Set<String> getBizCodeRightValues() {
        return bizCodeRightValues;
    }

    public static void setBizCodeRightValues(Set<String> bizCodeRightValues) {
        UrlStatsConfig.bizCodeRightValues = bizCodeRightValues;
    }

    public static List<String> getBizCodeRightValuePatterns() {
        return bizCodeRightValuePatterns;
    }

    public static void setBizCodeRightValuePatterns(List<String> bizCodeRightValuePatterns) {
        UrlStatsConfig.bizCodeRightValuePatterns = bizCodeRightValuePatterns;
    }

    public static Map<String, String> getCf2Router() {
        return cf2Router;
    }

    public static void setCf2Router(Map<String, String> cf2Router) {
        UrlStatsConfig.cf2Router = cf2Router;
    }

    private static class URLComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -4217763587351514524L;

        private URLComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Integer n;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Integer o1Index = 0;
            Integer o2Index = 0;
            Integer o1length = 0;
            Integer o2length = 0;
            String[] o1s = o1.split("/");
            String[] o2s = o2.split("/");
            for (String s : o1s) {
                if (s == null || "".equals(s)) continue;
                n = o1length;
                o1length = o1length + 1;
                if (s.indexOf("{") <= -1 && s.indexOf("*") <= -1) continue;
                n = o1Index;
                o1Index = o1Index + 1;
            }
            for (String s : o2s) {
                if (s == null || "".equals(s)) continue;
                n = o2length;
                o2length = o2length + 1;
                if (s.indexOf("{") <= -1 && s.indexOf("*") <= -1) continue;
                n = o2Index;
                o2Index = o2Index + 1;
            }
            int result = UrlStatsConfig.processResult(o1Index, o2Index, o1length, o2length);
            if (result != 0) {
                return result;
            }
            return o1.compareTo(o2);
        }
    }
}

