/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.common.url.StatusCodeStats;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlOverallAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStatusGroupAggregator;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsAggregator;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlUserAggregator;
import com.lubanops.apm.bootstrap.sample.SamplingStrategy;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UrlStatsCollector
extends Collector {
    public static final UrlStatsCollector INSTANCE = new UrlStatsCollector();
    private static final UrlStatsAggregator URL_STATS_AGGREGATOR = new UrlStatsAggregator();
    private static final UrlOverallAggregator URL_OVERALL_AGGREGATOR = new UrlOverallAggregator();
    private static final UrlStatusGroupAggregator URL_STATUS_GROUP_AGGREGATOR = new UrlStatusGroupAggregator();
    private static final UrlUserAggregator URL_USER_AGGREGATOR = new UrlUserAggregator();
    private static final UrlExceptionAggregator URL_EXCEPTION_AGGREGATOR = new UrlExceptionAggregator();
    private static int urlErrorCode = 400;
    private static boolean autoNormalize = false;
    private static Set<Integer> errorCodes = new HashSet<Integer>();

    public static void onStart(String uri, String method, String envId) {
        if (uri == null) {
            return;
        }
        URL_STATS_AGGREGATOR.onStart(uri, method, envId);
        URL_USER_AGGREGATOR.onStart(envId);
        URL_EXCEPTION_AGGREGATOR.onStart(uri, method);
    }

    public static void onThrowable(Throwable th) {
        URL_STATS_AGGREGATOR.onThrowable(th);
    }

    public static boolean onFinally(int code, String envId, String url, boolean hasException, String exceptionType) {
        boolean urlHasError = false;
        if (errorCodes.size() > 0) {
            if (errorCodes.contains(code)) {
                urlHasError = true;
            }
        } else if (code >= urlErrorCode) {
            urlHasError = true;
        }
        Map map = URL_STATS_AGGREGATOR.getContextMap();
        if ("true".equals(URL_STATS_AGGREGATOR.getContextValue(map, UrlStatsAggregator.tag_error))) {
            urlHasError = true;
        }
        UrlStats stat = (UrlStats)map.get("stats");
        long t = URL_STATS_AGGREGATOR.onFinally(code, url, urlHasError, map, hasException);
        if (t > 0L && URL_OVERALL_AGGREGATOR.isEnable()) {
            URL_OVERALL_AGGREGATOR.onTotal(t);
            URL_OVERALL_AGGREGATOR.onThreshold(stat, t);
            if (urlHasError) {
                URL_OVERALL_AGGREGATOR.onError();
            }
        }
        if (t > 0L && URL_STATUS_GROUP_AGGREGATOR.isEnable()) {
            StatusCodeStats statusCodeStats = URL_STATUS_GROUP_AGGREGATOR.onCode(code);
            statusCodeStats.getCount().incrementAndGet();
            statusCodeStats.getUrl().set(url);
        }
        String clusterIdValue = "user";
        if (!StringUtils.isBlank((String)envId)) {
            clusterIdValue = envId;
        }
        if (t > 0L && URL_USER_AGGREGATOR.isEnable()) {
            URL_USER_AGGREGATOR.onFinally(t, code, clusterIdValue, urlHasError);
            TransactionCollector.collect((long)t, (boolean)urlHasError, (String)clusterIdValue, (String)String.valueOf(IdentityConfigManager.getEnvId()), (List)TransactionCollector.getTxName(), (String)"Url");
        }
        URL_EXCEPTION_AGGREGATOR.onFinally(hasException, exceptionType);
        return urlHasError;
    }

    public static void clearThreadLocal() {
        URL_STATS_AGGREGATOR.clearThreadLocal();
    }

    public static Map<String, Object> getThreadLocalMap() {
        return URL_STATS_AGGREGATOR.getThreadLocalMap();
    }

    public static void setThreadLocalMap(Map<String, Object> map) {
        URL_STATS_AGGREGATOR.setThreadLocalMap(map);
    }

    public void parseParameter(Map<String, String> parameters) {
        if (parameters != null) {
            Integer globalSamplingRate = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"globalSamplingRate", Integer.class);
            if (globalSamplingRate != null) {
                ConfigManager.setGlobalSamplingRate((int)globalSamplingRate);
            } else {
                ConfigManager.setGlobalSamplingRate((int)100);
            }
            SamplingStrategy samplingStrategy = SamplingStrategy.valueOfLabel((String)((String)ParameterParseUtil.getParameterValue(parameters, (String)"samplingStrategy", String.class)));
            if (samplingStrategy != null) {
                ConfigManager.setSamplingStrategy((SamplingStrategy)samplingStrategy);
            } else {
                ConfigManager.setSamplingStrategy((SamplingStrategy)SamplingStrategy.INTELLIGENT);
            }
            Integer urlErrorCode = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"urlErrorCode", Integer.class);
            UrlStatsCollector.urlErrorCode = urlErrorCode != null ? urlErrorCode : 400;
            Integer maxSamplingThresholdPersecond = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"maxSamplingThr", Integer.class);
            if (maxSamplingThresholdPersecond != null) {
                if (maxSamplingThresholdPersecond < 0) {
                    maxSamplingThresholdPersecond = 0;
                } else if (maxSamplingThresholdPersecond > 200) {
                    maxSamplingThresholdPersecond = 200;
                }
                AgentConfigManager.setMaxSamplingThresholdPerSecond((int)maxSamplingThresholdPersecond);
            }
            String[] errorCodes = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"errorCodes", String[].class);
            HashSet<Integer> errorCodeSet = new HashSet<Integer>();
            if (errorCodes != null) {
                for (String errorCode : errorCodes) {
                    errorCodeSet.add(Integer.valueOf(errorCode));
                }
            }
            UrlStatsCollector.errorCodes = errorCodeSet;
            Boolean autoNormalize = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"autoNormalize", Boolean.class);
            UrlStatsCollector.autoNormalize = autoNormalize == null ? false : autoNormalize;
        } else {
            ConfigManager.setGlobalSamplingRate((int)100);
            ConfigManager.setSamplingStrategy((SamplingStrategy)SamplingStrategy.INTELLIGENT);
            urlErrorCode = 400;
            errorCodes = new HashSet<Integer>();
        }
    }

    public String getCollectorName() {
        return "Url";
    }

    public static boolean getAutoNormalize() {
        return autoNormalize;
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_STATS_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_OVERALL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_STATUS_GROUP_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_USER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

