/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlSlowRequestThreshold;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlAggregatorEnum;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.ExcludePattern;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlPattern;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UrlStatsAggregator
extends UrlAggregator<UrlStats> {
    static String tag_url = "url";
    static String tag_method = "method";
    static String tag_stats = "stats";
    static String tag_start = "start";
    static String tag_pk = "pk";
    static String tag_error = "error";
    private static final Logger LOGGER = LogFactory.getLogger();

    public String getName() {
        return UrlAggregatorEnum.url.name();
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_url, tag_method);
    }

    private void setStats(Map<String, String> parameters) {
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"slowRequestThreshold", Integer.class);
        this.setSlowRequestThreshold(slowRequestThreshold);
        Stats slowRequestTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"slowRequestTraceCountStats", Stats.class);
        this.setSlowRequestTraceCountStats(slowRequestTraceCountStats);
        Stats errorRequestTraceCounStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"errorRequestTraceCounStats", Stats.class);
        this.setErrorRequestTraceCounStats(errorRequestTraceCounStats);
        Stats requestTranceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"requestTranceCountStats", Stats.class);
        this.setRequestTranceCountStats(requestTranceCountStats);
    }

    private void setSampleConfig(Map<String, String> parameters) {
        String sampType = (String)ParameterParseUtil.getParameterValue(parameters, (String)"sampleType", String.class);
        String percentage = (String)ParameterParseUtil.getParameterValue(parameters, (String)"percentage", String.class);
        String periodCount = (String)ParameterParseUtil.getParameterValue(parameters, (String)"periodCount", String.class);
        this.getSampleConfig().setPercentage(percentage);
        this.getSampleConfig().setPeriodCount(periodCount);
        this.getSampleConfig().setSampleType(sampType);
    }

    public List<MonitorDataRow> harvest() {
        List result = super.harvest();
        if (UrlStatsCollector.getAutoNormalize()) {
            this.valueStats = new ConcurrentHashMap(100);
        }
        return result;
    }

    public void parseParameters(Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        this.setStats(parameters);
        this.setSampleConfig(parameters);
        Boolean bodyDetail = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"bodyDetail", Boolean.class);
        UrlStatsConfig.setBodyDetail(bodyDetail);
        Integer bodyLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"bodyLength", Integer.class);
        UrlStatsConfig.setBodyLength(bodyLength);
        String[] headerKeys = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"headerKeys", String[].class);
        UrlStatsConfig.setHeaderKeys(headerKeys);
        String[] parameterKeys = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"parameterKeys", String[].class);
        UrlStatsConfig.setParameterKeys(parameterKeys);
        String[] cookieKeys = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"cookieKeys", String[].class);
        UrlStatsConfig.setCookieKeys(cookieKeys);
        List patternArray = (List)ParameterParseUtil.getParameterValue(parameters, (String)"pattern", List.class, UrlPattern.class);
        UrlStatsConfig.setUrlList(patternArray);
        List excludeArray = (List)ParameterParseUtil.getParameterValue(parameters, (String)"exclude", List.class, ExcludePattern.class);
        UrlStatsConfig.setExcludeUrlList(excludeArray);
        List urlSlowRequestThresholds = (List)ParameterParseUtil.getParameterValue(parameters, (String)"urlslowRequestThreshold", List.class, UrlSlowRequestThreshold.class);
        this.setUrlSlowRequestThresholds(urlSlowRequestThresholds);
        Integer bizCodeLength = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"bizCodeLength", Integer.class);
        UrlStatsConfig.setBizCodeLength(bizCodeLength);
        String[] bizCodeFields = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"bizCodeFields", String[].class);
        UrlStatsConfig.setBizCodeFields(bizCodeFields);
        String[] bizCodeRightValues = (String[])ParameterParseUtil.getParameterValue(parameters, (String)"bizCodeRightValues", String[].class);
        UrlStatsConfig.setBizCodeRightValues(bizCodeRightValues);
        Boolean isGzip = (Boolean)ParameterParseUtil.getParameterValue(parameters, (String)"isGzip", Boolean.class);
        UrlStatsConfig.setIsGzip(isGzip);
        int[] range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"urlRange", int[].class);
        if (range != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(AbstractPrimaryKeyValueAggregator.getDefaultRanges());
        }
    }

    public long onFinally(int code, String nativeUrl, boolean hasError, Map<String, Object> map, boolean hasException) {
        if (!this.isEnable) {
            return 0L;
        }
        UrlStats stat = (UrlStats)this.getContextValue(map, tag_stats);
        Long t = (Long)this.getContextValue(map, tag_start);
        long useTime = 0L;
        if (stat != null && t != null) {
            useTime = stat.onFinally(t.longValue(), nativeUrl, hasError, hasException);
        } else {
            LOGGER.info("UrlStatsAggregator onFinally stat is null: " + (stat == null) + " t == null: " + (t == null));
        }
        if (code == 404) {
            PrimaryKey pk = (PrimaryKey)this.getContextValue(map, tag_pk);
            if (pk != null && null != stat && !stat.has200) {
                this.removeValue(pk);
            }
        } else if (null != stat) {
            stat.has200 = true;
        }
        map.clear();
        return useTime;
    }

    public void onStart(String url, String method, String envId) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{url, method});
        UrlStats stats = (UrlStats)this.getValue(pk);
        stats.setThreshold(this.getSlowRequestThreshold(url) / 4);
        stats.setIsRoot(envId);
        long start = stats.onStart();
        Map map = this.getContextMap();
        map.put(tag_stats, stats);
        map.put(tag_start, start);
        map.put(tag_pk, pk);
    }

    public void onThrowable(Throwable th) {
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        UrlStats stat = (UrlStats)this.getContextValue(map, tag_stats);
        if (stat != null) {
            map.put(tag_error, true);
        }
    }

    public String getUrlKey() {
        return tag_url;
    }

    protected Class<UrlStats> getValueType() {
        return UrlStats.class;
    }
}

