/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.exception.Slf4jListener;
import com.lubanops.apm.plugin.exception.common.collector.ExceptionCollector;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class Slf4jInterceptor
implements Interceptor {
    private Map<String, Method> methodMap = new HashMap<String, Method>();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            String flag = Slf4jListener.INTERCEPTOR_CLASSES_MAP.get(className);
            String logTypeError = "sl4j_" + flag + "_error";
            String version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)object.getClass().getProtectionDomain());
            if (flag.equals("logback")) {
                ExceptionCollector.setLogBackVersion((String)version);
            } else if (flag.equals("jcl")) {
                ExceptionCollector.setSlf4j_jcl((String)version);
            } else if (flag.equals("simple")) {
                ExceptionCollector.setSlf4j_simple((String)version);
            } else if (flag.equals("jdk14")) {
                ExceptionCollector.setSlf4j_jdk((String)version);
            } else if (flag.equals("log4j")) {
                ExceptionCollector.setSlf4j_log4j((String)version);
            }
            String logName = "unkown";
            if (object instanceof Logger) {
                logName = ((Logger)object).getName();
            } else {
                Method getNameMethod = this.methodMap.get(className);
                if (getNameMethod == null) {
                    Class<?> objClass = object.getClass();
                    getNameMethod = objClass.getDeclaredMethod("getName", new Class[0]);
                    this.methodMap.put(className, getNameMethod);
                }
                logName = (String)getNameMethod.invoke(object, new Object[0]);
            }
            String msg = null;
            Throwable th = null;
            for (Object arg : args) {
                if (msg == null && arg instanceof String) {
                    msg = (String)arg;
                    continue;
                }
                if (arg instanceof Throwable) {
                    th = (Throwable)arg;
                    continue;
                }
                if (!(arg instanceof Object[])) continue;
                for (Object argObj : (Object[])arg) {
                    if (msg == null && argObj instanceof String) {
                        msg = (String)argObj;
                        continue;
                    }
                    if (!(argObj instanceof Throwable)) continue;
                    th = (Throwable)argObj;
                }
            }
            ExceptionCollector.onError((String)logName, (String)logTypeError, msg, th);
        }
        catch (Exception e1) {
            LogFactory.log((Throwable)e1);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ExceptionCollector.clearContext();
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "Slf4jInterceptor onFinally", (Throwable)e);
        }
    }
}

