/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.handler;

import com.huawei.gaussdb.jdbc.jdbc.handler.TypeInfoHandler;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class GTypeInfoHandler
implements TypeInfoHandler {
    private ConcurrentHashMap<Integer, Integer> precisionToInteger = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Integer> oidToInteger = new ConcurrentHashMap();

    public GTypeInfoHandler() {
        this.precisionToInteger.put(5545, 3);
        this.precisionToInteger.put(21, 5);
        this.precisionToInteger.put(26, 10);
        this.precisionToInteger.put(23, 10);
        this.precisionToInteger.put(20, 19);
        this.precisionToInteger.put(700, 8);
        this.precisionToInteger.put(701, 17);
        this.precisionToInteger.put(18, 1);
        this.precisionToInteger.put(16, 1);
        this.oidToInteger.put(5545, 3);
        this.oidToInteger.put(21, 6);
        this.oidToInteger.put(23, 11);
        this.oidToInteger.put(26, 10);
        this.oidToInteger.put(20, 20);
        this.oidToInteger.put(700, 15);
        this.oidToInteger.put(701, 25);
        this.oidToInteger.put(18, 1);
        this.oidToInteger.put(16, 1);
        this.oidToInteger.put(1082, 13);
        this.oidToInteger.put(1186, 49);
    }

    @Override
    public boolean isSigned(int oid) {
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: 
            case 5545: 
            case 9003: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getScale(int oid, int mod) {
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (mod == -1) {
                    return 0;
                }
                return mod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (mod == -1) {
                    return 6;
                }
                return mod;
            }
            case 1186: {
                if (mod == -1) {
                    return 6;
                }
                return mod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public int getPrecision(int oid, int mod, int defaultLength) {
        if (this.precisionToInteger.containsKey(oid)) {
            return this.precisionToInteger.get(oid);
        }
        switch (oid) {
            case 1700: {
                if (mod == -1) {
                    return 0;
                }
                return (mod - 4 & 0xFFFF0000) >> 16;
            }
            case 1042: 
            case 1043: 
            case 3969: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 9003: {
                return this.getDisplaySize(oid, mod, defaultLength);
            }
            case 1560: {
                return mod;
            }
            case 1562: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod;
            }
        }
        return defaultLength;
    }

    @Override
    public int getDisplaySize(int oid, int mod, int defaultLength) {
        if (this.oidToInteger.containsKey(oid)) {
            return this.oidToInteger.get(oid);
        }
        switch (oid) {
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: 
            case 9003: {
                return this.getValueOfTime(oid, mod);
            }
            case 1042: 
            case 1043: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod - 4;
            }
            case 1700: {
                if (mod == -1) {
                    return 131089;
                }
                int precision = (mod - 4 & 0xFFFF0000) >> 16;
                int scale = mod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1562: {
                if (mod == -1) {
                    return defaultLength;
                }
                return mod;
            }
            case 1560: {
                return mod;
            }
        }
        return defaultLength;
    }

    private int getValueOfTime(int oid, int mod) {
        int secondSize;
        switch (mod) {
            case -1: {
                secondSize = 7;
                break;
            }
            case 0: {
                secondSize = 0;
                break;
            }
            case 1: {
                secondSize = 3;
                break;
            }
            default: {
                secondSize = mod + 1;
            }
        }
        switch (oid) {
            case 1083: {
                return 8 + secondSize;
            }
            case 1266: {
                return 8 + secondSize + 6;
            }
            case 9003: {
                return 22;
            }
            case 1114: {
                return 22 + secondSize;
            }
        }
        return 22 + secondSize + 6;
    }

    public String toString() {
        return "GTypeInfoHandler{precisionToInteger=" + this.precisionToInteger + ", oidToInteger=" + this.oidToInteger + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GTypeInfoHandler)) {
            return false;
        }
        GTypeInfoHandler that = (GTypeInfoHandler)o;
        return Objects.equals(this.precisionToInteger, that.precisionToInteger) && Objects.equals(this.oidToInteger, that.oidToInteger);
    }

    public int hashCode() {
        return Objects.hash(this.precisionToInteger, this.oidToInteger);
    }
}

