/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTThreadFactory;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionPropParser;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.GnsConnStatus;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GnsConnectionMonitor {
    private static final Long GNS_CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    private static final int GNS_MAX_NUM = 4;
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(3, new ALTThreadFactory());
    private final Set<String> altClusterIdSet = new HashSet<String>();
    private final Map<String, GnsConnectTask> gnsConnectMap = new ConcurrentHashMap<String, GnsConnectTask>();
    private final Map<String, Long> gnsConnectTimeoutMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, ScheduledFuture<?>> scheduledFutureMap = new ConcurrentHashMap();

    private GnsConnectionMonitor() {
    }

    public static GnsConnectionMonitor getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public synchronized void register(Properties props, Runnable runnable) {
        String altClusterId = GnsConnectionPropParser.getAltClusterId(props);
        if (this.altClusterIdSet.contains(altClusterId)) {
            return;
        }
        this.altClusterIdSet.add(altClusterId);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleWithFixedDelay(runnable, 0L, 3L, TimeUnit.SECONDS);
        this.scheduledFutureMap.put(altClusterId, scheduledFuture);
    }

    public synchronized void unRegister(String altClusterId) {
        ScheduledFuture<?> scheduledFuture = this.scheduledFutureMap.get(altClusterId);
        if (scheduledFuture == null) {
            return;
        }
        scheduledFuture.cancel(false);
        this.gnsConnectMap.remove(altClusterId);
        this.altClusterIdSet.remove(altClusterId);
        this.gnsConnectTimeoutMap.remove(altClusterId);
        this.scheduledFutureMap.remove(altClusterId);
    }

    public GnsConnectTask findGnsConnectTask(String altClusterId) {
        return this.gnsConnectMap.get(altClusterId);
    }

    public boolean isGnsConnected(String altClusterId) {
        GnsConnectTask gnsConnectTask = this.gnsConnectMap.get(altClusterId);
        return gnsConnectTask != null && gnsConnectTask.getGnsConnStatus() == GnsConnStatus.CONNECTED;
    }

    public void addGnsConnectTask(String altClusterId, GnsConnectTask gnsConnectTask) {
        this.gnsConnectMap.put(altClusterId, gnsConnectTask);
    }

    public void registerGnsConnectTimeout(String altClusterId, long gnsConnectTimeout) {
        if (altClusterId != null && gnsConnectTimeout > 0L) {
            this.gnsConnectTimeoutMap.put(altClusterId, gnsConnectTimeout);
        }
    }

    public long getGnsConnectTimeout(String altClusterId) {
        Long connectTimeout = this.gnsConnectTimeoutMap.get(altClusterId);
        return connectTimeout == null || connectTimeout <= 0L ? GNS_CONNECT_TIMEOUT : connectTimeout;
    }

    public long getAllGnsConnectTimeout(String altClusterId, int gnsNum) {
        long gnsConnectTimeout = this.getGnsConnectTimeout(altClusterId);
        int realNum = gnsNum <= 0 ? 4 : gnsNum + 1;
        return gnsConnectTimeout * (long)realNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GnsConnectionMonitor)) {
            return false;
        }
        GnsConnectionMonitor that = (GnsConnectionMonitor)o;
        return Objects.equals(this.executorService, that.executorService) && Objects.equals(this.altClusterIdSet, that.altClusterIdSet);
    }

    public int hashCode() {
        return Objects.hash(this.executorService, this.altClusterIdSet);
    }

    public String toString() {
        return "GnsConnectionMonitor{executorService=" + this.executorService + ", altClusterIdSet=" + this.altClusterIdSet + '}';
    }

    private static final class InstanceHolder {
        static final GnsConnectionMonitor INSTANCE = new GnsConnectionMonitor();

        private InstanceHolder() {
        }
    }
}

