/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.Driver;
import com.huawei.gaussdb.jdbc.core.PGStream;
import com.huawei.gaussdb.jdbc.core.v3.ConnectionFactoryImpl;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.ClusterRole;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.ClusterType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.JDBCMsgType;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.GnsStartupPacket;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.InitDBConnMsg;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.ByteConvertUtil;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.ssl.MakeSSL;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.ServerErrorMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

public class GnsConnectionImpl
implements GnsConnection {
    private static final Log LOGGER = Logger.getLogger(GnsConnectionImpl.class.getName());
    private static final int LENGTH_BYTE_NUM = 4;
    private static final int GNS_CONNECT_TIMEOUT_NUM = 4;
    private static final int IP_BYTE_NUM = 128;
    private static final int PORT_BYTE_NUM = 4;
    private static final int STATUS_BYTE_NUM = 4;
    private static final int FILL_BYTE_NUM = 4;
    private static final int CLUSTER_TYPE_BYTE_NUM = 4;
    private static final int CLUSTER_ROLE_BYTE_NUM = 4;
    private static final int ENABLE_SSL_BYTE_NUM = 4;
    private static final int SSL_MODE_BYTE_NUM = 4;
    private static final int JDBC_MSG_BYTE_NUM = 4;
    private static final int IP_NUM = 3;
    private static final long DISCONNECTED_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private PGStream gnsStream;
    private final String altClusterId;
    private final HostSpec hostSpec;
    private final Properties props;
    private long lastReceivePacketTime;

    public GnsConnectionImpl(String altClusterId, HostSpec hostSpec, Properties props) {
        this.altClusterId = altClusterId;
        this.hostSpec = hostSpec;
        this.props = props;
        this.lastReceivePacketTime = System.currentTimeMillis();
    }

    @Override
    public ServerErrorMessage receiveErrorMsg() throws IOException {
        int length = this.gnsStream.receiveInteger4();
        String connectInfo = this.gnsStream.getConnectInfo();
        return new ServerErrorMessage(this.gnsStream.receiveErrorString(length - 4), connectInfo);
    }

    @Override
    public void connect(SocketFactory socketFactory, long timeout) throws IOException {
        this.gnsStream = new PGStream(socketFactory, this.hostSpec, (int)timeout);
        this.sendGnsStartUpPacket();
    }

    @Override
    public boolean receiveStartUpRes() throws IOException {
        this.gnsStream.receive(8);
        int isSupportSSL = this.gnsStream.receiveInteger4();
        return isSupportSSL != 0;
    }

    @Override
    public void convertToSSL() throws IOException {
        try {
            MakeSSL.convert(this.gnsStream, this.props);
        }
        catch (PSQLException e) {
            LoggerUtil.warn(LOGGER, "Unable to be converted to SSL connection : " + e.getServerErrorMessage());
        }
    }

    @Override
    public void receiveTacCompleteRes() throws IOException {
        this.gnsStream.receive(8);
    }

    @Override
    public void doAuthentication() throws IOException, SQLException {
        this.gnsStream.receiveInteger4();
        byte[] receive = this.gnsStream.receive(8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(receive);
        int enableSSL = ByteConvertUtil.int4From(byteArrayInputStream, true);
        int sslMode = ByteConvertUtil.int4From(byteArrayInputStream, true);
        if (enableSSL != 0 && sslMode == 1) {
            return;
        }
        ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl();
        HostSpec[] urlHostSpecs = Driver.GetHostSpecs(this.props);
        connectionFactoryImpl.doAuthenticationWithGns(this.gnsStream, this.props, urlHostSpecs[0]);
    }

    @Override
    public boolean isDisconnected() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.lastReceivePacketTime >= DISCONNECTED_TIMEOUT;
    }

    @Override
    public FanTask receiveFanMsg() throws IOException {
        int length = this.gnsStream.receiveInteger4();
        byte[] data = this.gnsStream.receive(length - 4);
        FanTask fanTask = new FanTask();
        fanTask.deserialize(data);
        fanTask.setConn(this);
        return fanTask;
    }

    @Override
    public char receiveMsgType() throws IOException {
        char c = (char)this.gnsStream.receiveChar();
        this.lastReceivePacketTime = System.currentTimeMillis();
        return c;
    }

    @Override
    public InitDBConnMsg receiveInitMsg() throws IOException {
        InitDBConnMsg fanInitMsg = new InitDBConnMsg();
        int length = this.gnsStream.receiveInteger4();
        int connectionTimeout = this.receiveInt4();
        fanInitMsg.setReConnectTimeout(TimeUnit.SECONDS.toMillis(connectionTimeout));
        int num = (length - 4 - 4) / 400;
        ArrayList<HostSpec> hostSpecs = new ArrayList<HostSpec>();
        ArrayList<Integer> hostStatus = new ArrayList<Integer>();
        for (int i = 0; i < num; ++i) {
            ArrayList<String> ips = new ArrayList<String>(3);
            for (int j = 0; j < 3; ++j) {
                ips.add(ByteConvertUtil.removeSuffix(this.gnsStream.receiveString(128)));
            }
            int port = this.gnsStream.receiveInteger4();
            int status = this.receiveInt4();
            for (int j = 0; j < 3; ++j) {
                String s = (String)ips.get(j);
                if (s == null || s.isEmpty()) continue;
                hostSpecs.add(new HostSpec((String)ips.get(j), port));
                hostStatus.add(status);
            }
            fanInitMsg.setDist(ClusterType.of(this.gnsStream.receiveInteger4()));
            fanInitMsg.setClusterRole(ClusterRole.of(this.receiveInt4()));
        }
        fanInitMsg.setAltClusterId(this.getAltClusterId());
        fanInitMsg.setHostSpecs(hostSpecs);
        fanInitMsg.setHostStatuses(hostStatus);
        return fanInitMsg;
    }

    private int receiveInt4() throws IOException {
        return this.gnsStream.receiveInteger4();
    }

    @Override
    public void receiveHeartBeatRes() throws IOException {
        this.gnsStream.receive(8);
    }

    @Override
    public synchronized void sendHeartBeatPacket() throws IOException {
        this.gnsStream.sendChar(67);
        this.gnsStream.sendInteger4(8);
        this.gnsStream.sendInteger4(JDBCMsgType.HEARTBEAT.getValue());
        this.gnsStream.flush();
    }

    @Override
    public synchronized void sendGnsStartUpPacket() throws IOException {
        this.gnsStream.sendChar(65);
        GnsStartupPacket gnsStartupPacket = new GnsStartupPacket(this.props);
        this.gnsStream.send(gnsStartupPacket.toBytes());
        this.gnsStream.flush();
    }

    @Override
    public synchronized void sendDNStartUpPacket() throws IOException {
        ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl();
        connectionFactoryImpl.sendGnsDnStartupPacket(this.gnsStream, this.props);
    }

    @Override
    public synchronized void sendAckPacket() throws IOException {
        this.gnsStream.sendChar(67);
        this.gnsStream.sendInteger4(8);
        this.gnsStream.sendInteger4(JDBCMsgType.TAC_ACK.getValue());
        this.gnsStream.flush();
    }

    @Override
    public void close() {
        if (this.gnsStream != null) {
            try {
                this.gnsStream.close();
            }
            catch (IOException e) {
                LoggerUtil.warn(LOGGER, "Can't close gnsStream:" + e.getMessage());
            }
        }
    }

    @Override
    public boolean isClosed() {
        if (this.gnsStream == null) {
            return true;
        }
        if (this.gnsStream.getSocket() == null) {
            return true;
        }
        return this.gnsStream.getSocket().isClosed();
    }

    @Override
    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public String getAltClusterId() {
        return this.altClusterId;
    }

    public String toString() {
        return "GnsConnectionImpl{altClusterId='" + this.altClusterId + '\'' + ", hostSpec=" + this.hostSpec + '}';
    }
}

