/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.connection;

import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionFactory;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsConnectionPropParser;
import com.huawei.gaussdb.jdbc.jdbc.alt.connection.GnsLockManager;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanEventType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.GnsConnStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.DBConnectionTracker;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.InitDBConnMsg;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacLock;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.huawei.gaussdb.jdbc.util.ServerErrorMessage;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;

public class GnsConnectTask
implements Runnable {
    private static final Log LOGGER = Logger.getLogger(GnsConnectTask.class.getName());
    private final LinkedBlockingQueue<FanTask> fanTaskQueue = new LinkedBlockingQueue();
    private final Properties props;
    private final List<HostSpec> gnsServers;
    private final String altClusterId;
    private final TacLock tacLock = new TacLock();
    private final ALTContext context;
    private GnsConnection conn;
    private volatile GnsConnStatus gnsConnStatus = GnsConnStatus.INIT;
    private volatile boolean isTacTimeout = false;

    public GnsConnectTask(Properties props, ALTContext context) {
        this.props = props;
        this.gnsServers = GnsConnectionPropParser.getGnsHostSpecs(props);
        this.altClusterId = GnsConnectionPropParser.getAltClusterId(props);
        this.context = context;
    }

    @Override
    public void run() {
        LoggerUtil.debug(LOGGER, "Begin gns connect task");
        try {
            this.connectToGns();
            this.startFanProcessTask();
            this.startMainLoop();
        }
        catch (IOException e) {
            LoggerUtil.warn(LOGGER, "The connection between jdbc and gns is disconnected:" + e.getMessage());
        }
        catch (ALTException e) {
            LoggerUtil.warn(LOGGER, e.getMessage());
        }
        catch (SQLException e) {
            LoggerUtil.warn(LOGGER, "Jdbc and gns failed to be authenticated");
        }
        finally {
            this.gnsConnStatus = GnsConnStatus.CLOSED;
            this.unlockConnection();
            this.close();
            this.exitFanTask();
            LoggerUtil.debug(LOGGER, "Exit gns connect task");
        }
    }

    private void connectToGns() throws ALTException {
        GnsConnectionFactory gnsConnectionFactory = this.context.buildGnsConnectionFactory();
        this.conn = gnsConnectionFactory.openGnsConnection(this.props, this.context.getGnsConnectTimeout(this.altClusterId));
    }

    private void startFanProcessTask() {
        this.context.startFanProcessTask(this.fanTaskQueue);
    }

    private void startMainLoop() throws IOException, ALTException, SQLException {
        block10: while (this.conn != null && this.gnsConnStatus != GnsConnStatus.TIME_OUT) {
            char msgType = this.conn.receiveMsgType();
            switch (msgType) {
                case 'R': {
                    boolean isEnableSSL = this.conn.receiveStartUpRes();
                    if (isEnableSSL) {
                        this.conn.convertToSSL();
                    }
                    this.conn.sendDNStartUpPacket();
                    continue block10;
                }
                case 'E': {
                    ServerErrorMessage serverErrorMessage = this.conn.receiveErrorMsg();
                    throw new ALTException("jdbc fails to connect gns, errMsg is " + serverErrorMessage);
                }
                case 'D': {
                    ServerErrorMessage serverErrorMessage = this.conn.receiveErrorMsg();
                    throw new IOException("gns refuses to set up a connection with jdbc, errMsg is " + serverErrorMessage);
                }
                case 'F': {
                    FanTask fanTask = this.dealWithFanTask();
                    if (fanTask.getFanEventType() != FanEventType.TAC_TIMEOUT) continue block10;
                    this.isTacTimeout = true;
                    this.unLockCluster();
                    return;
                }
                case 'I': {
                    this.dealWithInitMsg();
                    this.gnsConnStatus = GnsConnStatus.CONNECTED;
                    this.unlockConnection();
                    this.unLockCluster();
                    continue block10;
                }
                case 'H': {
                    this.conn.receiveHeartBeatRes();
                    continue block10;
                }
                case 'P': {
                    this.conn.doAuthentication();
                    continue block10;
                }
                case 'O': {
                    this.dealWithTacCompleteMsg();
                    continue block10;
                }
            }
            throw new ALTException("UnKnow MsgType " + msgType);
        }
    }

    private void dealWithInitMsg() throws IOException {
        InitDBConnMsg fanInitMsg = this.conn.receiveInitMsg();
        fanInitMsg.setAltClusterId(this.altClusterId);
        this.initDbConnManager(fanInitMsg);
        this.context.registerGnsConnectTimeout(this.altClusterId, fanInitMsg.getReConnectTimeout());
    }

    private FanTask dealWithFanTask() throws IOException {
        FanTask fanTask = this.conn.receiveFanMsg();
        fanTask.setAltClusterId(this.altClusterId);
        this.fillRemoteHost(fanTask);
        LoggerUtil.debug(LOGGER, fanTask.toString());
        try {
            this.fanTaskQueue.put(fanTask);
        }
        catch (InterruptedException e) {
            LoggerUtil.warn(LOGGER, "InterruptedException as put FanTask in taskQueue");
        }
        return fanTask;
    }

    private void dealWithTacCompleteMsg() throws IOException, ALTException {
        this.conn.receiveTacCompleteRes();
        this.unLockCluster();
        LoggerUtil.debug(LOGGER, "Capture reconnection flag");
    }

    void close() {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public GnsConnStatus getGnsConnStatus() {
        return this.gnsConnStatus;
    }

    public boolean isDisconnected() {
        return this.conn == null || this.conn.isDisconnected();
    }

    public boolean isClosed() {
        return this.gnsConnStatus == GnsConnStatus.CLOSED;
    }

    public boolean isTacTimeout() {
        return this.isTacTimeout;
    }

    private void exitFanTask() {
        FanTask exitFanTask = new FanTask();
        exitFanTask.setAltClusterId(this.altClusterId);
        exitFanTask.setFanEventType(FanEventType.EXIT);
        try {
            this.fanTaskQueue.put(exitFanTask);
        }
        catch (InterruptedException e) {
            LoggerUtil.warn(LOGGER, "Can't send exitFanTask to FanTaskProcessTask");
        }
    }

    public GnsConnection getConn() {
        return this.conn;
    }

    public Properties getProperty() {
        return this.props;
    }

    public void setGnsConnStatus(GnsConnStatus gnsConnStatus) {
        this.gnsConnStatus = gnsConnStatus;
    }

    public boolean waitOnLock(long timeMillis) {
        return this.tacLock.waitOnLock(timeMillis);
    }

    public void lock() {
        this.tacLock.lock();
    }

    private void unlockConnection() {
        try {
            this.tacLock.unlock();
        }
        catch (ALTException e) {
            LoggerUtil.warn(LOGGER, e.getMessage());
        }
    }

    public boolean hasLock() {
        return this.tacLock.hasLock();
    }

    private void initDbConnManager(InitDBConnMsg fanInitMsg) {
        DBConnectionTracker dbConnectionTracker = this.context.getDBConnectionTracker();
        dbConnectionTracker.initDbConnManager(fanInitMsg);
    }

    private void fillRemoteHost(FanTask fanTask) {
        DBConnectionTracker dbConnectionTracker = this.context.getDBConnectionTracker();
        dbConnectionTracker.fillRemoteHost(fanTask);
    }

    private void unLockCluster() throws ALTException {
        GnsLockManager gnsLockManager = this.context.getGnsLockManager();
        gnsLockManager.unlock(this.altClusterId);
    }

    public String toString() {
        return "GnsConnectTask{altClusterId=" + this.altClusterId + ", hostSpec='" + (this.conn != null ? this.conn.getHostSpec() : "") + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GnsConnectTask)) {
            return false;
        }
        GnsConnectTask that = (GnsConnectTask)o;
        return Objects.equals(this.props, that.props) && Objects.equals(this.fanTaskQueue, that.fanTaskQueue) && Objects.equals(this.conn, that.conn) && Objects.equals(this.gnsServers, that.gnsServers) && Objects.equals(this.altClusterId, that.altClusterId);
    }

    public int hashCode() {
        return Objects.hash(this.props, this.fanTaskQueue, this.conn, this.gnsServers, this.altClusterId);
    }
}

