/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc;

import com.huawei.gaussdb.jdbc.CompatibilityModeEnum;
import com.huawei.gaussdb.jdbc.core.BaseConnection;
import com.huawei.gaussdb.jdbc.core.BaseStatement;
import com.huawei.gaussdb.jdbc.core.TypeInfo;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PGobject;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> _pgNameToSQLType;
    private Map<String, String> _pgNameToJavaClass;
    private Map<Integer, String> _oidToPgName;
    private Map<String, Integer> _pgNameToOid;
    private Map<String, Class<? extends PGobject>> _pgNameToPgObject;
    private Map<Integer, Integer> _pgArrayToPgType;
    private Map<Integer, Character> _arrayOidToDelimiter;
    private BaseConnection _conn;
    private final int _unknownLength;
    private PreparedStatement _getOidStatementSimple;
    private PreparedStatement _getNameStatement;
    private PreparedStatement _getArrayElementOidStatement;
    private PreparedStatement _getArrayDelimiterStatement;
    private PreparedStatement _getTypeInfoStatement;
    private PreparedStatement cacheTypeInfoStatement;
    static final Object[][] M_TYPES = new Object[][]{{"int1", 5545, -6, "java.lang.Integer", 5546}, {"int2", 21, 5, "java.lang.Integer", 1005}, {"mediumint", 9877, 4, "java.lang.Integer", 0}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"int8", 20, -5, "java.lang.Long", 1016}, {"uint1", 349, 4, "java.lang.Integer", 1072}, {"uint2", 352, 4, "java.lang.Integer", 1073}, {"mediumint unsigned", 9621, 4, "java.lang.Integer", 0}, {"uint4", 353, -5, "java.lang.Long", 1074}, {"uint8", 388, -5, "java.math.BigInteger", 1075}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"binary", 9974, -2, "[B", 0}, {"varbinary", 9881, -3, "[B", 0}, {"tinytext", 9880, 12, "java.lang.String", 0}, {"text", 25, 12, "java.lang.String", 1009}, {"mediumtext", 9878, 12, "java.lang.String", 0}, {"longtext", 9976, 12, "java.lang.String", 0}, {"bit", 1560, -7, "[B", 1561}, {"datetime", 9876, 93, "java.sql.Timestamp", 0}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"year", 1038, 91, "java.sql.Date", 1076}};
    private static final int INITIAL_MAP_SIZE = 100;
    private static final Object[][] types = new Object[][]{{"int1", 5545, -6, "java.lang.Integer", 5546}, {"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"uint1", 349, 4, "java.lang.Integer", 1072}, {"uint2", 352, 4, "java.lang.Integer", 1073}, {"uint4", 353, -5, "java.lang.Long", 1074}, {"uint8", 388, 2, "java.math.BigDecimal", 1075}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"smalldatetime", 9003, 93, "java.lang.Timestamp", 9005}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"year", 1038, 1111, "com.huawei.gaussdb.jdbc.util.PGobject", 1076}, {"json", 114, 1111, "com.huawei.gaussdb.jdbc.util.PGobject", 199}, {"point", 600, 1111, "com.huawei.gaussdb.jdbc.geometric.PGpoint", 1017}, {"nvarchar2", 3969, 12, "java.lang.String", 3968}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}};
    private static final HashMap<String, String> typeAliases = new HashMap();

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this._conn = conn;
        this._unknownLength = unknownLength;
        this._oidToPgName = new HashMap<Integer, String>();
        this._pgNameToOid = new HashMap<String, Integer>();
        this._pgNameToJavaClass = new HashMap<String, String>();
        this._pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>();
        this._pgArrayToPgType = new HashMap<Integer, Integer>();
        this._arrayOidToDelimiter = new HashMap<Integer, Character>();
        this._pgNameToSQLType = Collections.synchronizedMap(new HashMap());
        for (Object[] type : types) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this._pgNameToJavaClass.put(pgTypeName, javaClass);
        this._pgNameToOid.put(pgTypeName, oid);
        this._oidToPgName.put(oid, pgTypeName);
        this._pgArrayToPgType.put(arrayOid, oid);
        this._pgNameToSQLType.put(pgTypeName, sqlType);
        Character delim = Character.valueOf(',');
        this._arrayOidToDelimiter.put(oid, delim);
        String pgArrayTypeName = pgTypeName + "[]";
        this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this._pgNameToSQLType.put(pgArrayTypeName, 2003);
        this._pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        if (!this._pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this._pgNameToSQLType.put(pgArrayTypeName, 2003);
            this._pgNameToOid.put(pgArrayTypeName, arrayOid);
            this._oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this._pgNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    public void preCacheSQLTypes() throws SQLException {
        if (this.cacheTypeInfoStatement == null) {
            String sql = "SELECT typname, typinput='array_in'::regproc, typtype FROM pg_catalog.pg_type LEFT JOIN (select ns.oid as nspoid, ns.nspname, r.r     from pg_namespace as ns     join ( select s.r, (pg_catalog.current_schemas(false))[s.r] as nspname         from pg_catalog.generate_series(1, pg_catalog.array_upper(pg_catalog.current_schemas(false), 1)) as s(r) ) as r     using ( nspname )     where ns.nspname  != 'pg_toast') as sp ON sp.nspoid = typnamespace ORDER BY typname, sp.r, pg_type.oid DESC;";
            this.cacheTypeInfoStatement = this._conn.prepareStatement(sql);
            if (this.cacheTypeInfoStatement instanceof BaseStatement && !((BaseStatement)((Object)this.cacheTypeInfoStatement)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
            }
            this.handleResultSet();
        }
    }

    private void handleResultSet() throws SQLException {
        ResultSet rs = this.cacheTypeInfoStatement.getResultSet();
        while (rs.next()) {
            String typeName = rs.getString(1);
            if (this._pgNameToSQLType.containsKey(typeName)) continue;
            Integer type = null;
            boolean isArray = rs.getBoolean(2);
            String typtype = rs.getString(3);
            type = isArray ? Integer.valueOf(2003) : ("c".equals(typtype) ? Integer.valueOf(2002) : ("d".equals(typtype) ? Integer.valueOf(2001) : Integer.valueOf(1111)));
            this._pgNameToSQLType.put(typeName, type);
        }
        rs.close();
    }

    @Override
    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this._pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        int workingVersionNum = Integer.parseInt(this._conn.getQueryExecutor().getWorkingVersionNum());
        if (this._getTypeInfoStatement == null) {
            String sql = "SELECT typinput, typtype FROM ";
            sql = sql + "pg_catalog.";
            sql = sql + "pg_type WHERE typname = ?";
            if (workingVersionNum >= 92820) {
                String suffix = this._conn.getCompatibilityMode() == CompatibilityModeEnum.MYSQL ? " union all (SELECT a.typinput, a.typtype FROM ( SELECT pg_catalog.concat(pn.nspname::text, '.'::text, pt.typname::text) AS typname, pt.typinput, pt.typtype FROM pg_namespace pn LEFT JOIN pg_type pt ON pn.oid = pt.typnamespace) a WHERE a.typname = ? and a.typtype <>'c');" : " union all (SELECT a.typinput, a.typtype FROM ( SELECT pn.nspname || '.' || pt.typname AS typname, pt.typinput, pt.typtype FROM pg_namespace pn LEFT JOIN pg_type pt ON pn.oid = pt.typnamespace) a WHERE a.typname = ? and a.typtype <>'c');";
                sql = sql + suffix;
            }
            this._getTypeInfoStatement = this._conn.prepareStatement(sql);
        }
        this._getTypeInfoStatement.setString(1, pgTypeName);
        if (workingVersionNum >= 92820) {
            this._getTypeInfoStatement.setString(2, pgTypeName);
        }
        if (!((BaseStatement)((Object)this._getTypeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getTypeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            String typinput = rs.getString(1);
            String typtype = rs.getString(2);
            if (typinput.equals("array_in") || typinput.equals("nesttable_in")) {
                type = 2003;
            } else if ("c".equals(typtype)) {
                type = 2002;
            } else if ("d".equals(typtype)) {
                type = 2001;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        this._pgNameToSQLType.put(pgTypeName, type);
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        if (this._getOidStatementSimple == null) {
            String sql = this._conn.getCompatibilityMode() == CompatibilityModeEnum.MYSQL ? "select pt.oid as oid, pg_catalog.concat(pn.nspname::text, '.'::text, pt.typname::text) as typname from pg_namespace pn left join pg_type pt on pn.oid=pt.typnamespace where pg_catalog.concat(pn.nspname::text, '.'::text, pt.typname::text) = ?  union ( select pt.oid as oid, pg_catalog.concat(pn.nspname::text, '.'::text, pt.typname::text) as typname from pg_namespace pn left join pg_type pt on pn.oid=pt.typnamespace where nspname in('pg_catalog', pg_catalog.current_schema()) and typname = ? order by pg_catalog.current_schema()=pn.nspname desc limit 1 ) limit 1" : "select pt.oid as oid, pn.nspname || '.' || pt.typname as typname from pg_namespace pn left join pg_type pt on pn.oid=pt.typnamespace where pn.nspname || '.' || pt.typname = ?  union ( select pt.oid as oid, pn.nspname || '.' || pt.typname as typname from pg_namespace pn left join pg_type pt on pn.oid=pt.typnamespace where nspname in('pg_catalog', pg_catalog.current_schema()) and typname = ? order by pg_catalog.current_schema()=pn.nspname desc limit 1 ) limit 1";
            this._getOidStatementSimple = this._conn.prepareStatement(sql);
        }
        this._getOidStatementSimple.setString(1, pgTypeName);
        this._getOidStatementSimple.setString(2, pgTypeName);
        return this._getOidStatementSimple;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this._oidToPgName.put(oid, internalName);
            this._pgNameToOid.put(internalName, oid);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        if (oid == 0 && pgTypeName.contains(".")) {
            oid = this.tryQueryTypeOidWithPkg(pgTypeName);
        }
        return oid;
    }

    private int tryQueryTypeOidWithPkg(String typeNameWithPkg) throws SQLException {
        int oid = 0;
        if (typeNameWithPkg == null || typeNameWithPkg.isEmpty()) {
            return oid;
        }
        int lastIndex = typeNameWithPkg.indexOf(46);
        String tmpPkgName = typeNameWithPkg.substring(0, lastIndex);
        String typePattern = typeNameWithPkg.substring(lastIndex);
        Map<String, Integer> typeNameToOidWithPattern = this.getTypeNameToOidWithPattern(typePattern);
        oid = this.getTypeOidWithPkg(typeNameToOidWithPattern, tmpPkgName);
        this._pgNameToOid.put(typeNameWithPkg, oid);
        return oid;
    }

    private int getTypeOidWithPkg(Map<String, Integer> typeMap, String tmpPkgName) throws SQLException {
        int oid = 0;
        for (String str : typeMap.keySet()) {
            int firstIndex;
            String pkgOid = str.substring(0, firstIndex = str.indexOf(46));
            if (!this.isNumber(pkgOid)) continue;
            String pkgInfo = this.getPkgInfo(pkgOid);
            int index = pkgInfo.indexOf(45);
            int pkgNamespaceOid = Integer.parseInt(pkgInfo.substring(0, index));
            String pkgName = pkgInfo.substring(index + 1);
            if ("".equals(pkgName) || !tmpPkgName.contains(pkgName)) continue;
            String pkgNamespace = this.getPkgNamespace(pkgNamespaceOid);
            oid = typeMap.getOrDefault(str, 0);
            String internalName = pkgNamespace + "." + str;
            this._oidToPgName.put(oid, internalName);
            this._pgNameToOid.put(internalName, oid);
            break;
        }
        return oid;
    }

    private String getPkgNamespace(int oid) throws SQLException {
        try (PreparedStatement preparedStatement = this._conn.prepareStatement("select nspname from pg_namespace where oid = ?");){
            preparedStatement.setInt(1, oid);
            if (preparedStatement instanceof BaseStatement && !((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            ResultSet resultSet = preparedStatement.getResultSet();
            String namespace = "";
            if (resultSet.next()) {
                namespace = resultSet.getString(1);
            }
            resultSet.close();
            String string = namespace;
            return string;
        }
    }

    private String getPkgInfo(String oid) throws SQLException {
        String pkgInfo = "";
        try (PreparedStatement preparedStatement = this._conn.prepareStatement("select pkgnamespace,pkgname from gs_package where oid=?");){
            preparedStatement.setInt(1, Integer.parseInt(oid));
            if (preparedStatement instanceof BaseStatement && !((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            ResultSet resultSet = preparedStatement.getResultSet();
            if (resultSet.next()) {
                Integer pkgNamespaceOid = resultSet.getInt(1);
                String pkgName = resultSet.getString(2);
                pkgInfo = pkgNamespaceOid + "-" + pkgName;
            }
            resultSet.close();
            String string = pkgInfo;
            return string;
        }
    }

    private boolean isNumber(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Integer> getTypeNameToOidWithPattern(String pattern) throws SQLException {
        try (PreparedStatement preparedStatement = this._conn.prepareStatement("select oid,typname from pg_type where typname like ?");){
            preparedStatement.setString(1, "%" + pattern);
            if (preparedStatement instanceof BaseStatement && !((BaseStatement)((Object)preparedStatement)).executeWithFlags(16)) {
                throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(100);
            ResultSet resultSet = preparedStatement.getResultSet();
            while (resultSet.next()) {
                String typeName = resultSet.getString(2);
                int typeOid = resultSet.getInt(1);
                map.put(typeName, typeOid);
            }
            resultSet.close();
            HashMap<String, Integer> hashMap = map;
            return hashMap;
        }
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = this._oidToPgName.get(oid);
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this._getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(pg_catalog.current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                pgTypeName = name;
                this._pgNameToOid.put(schema + "." + name, oid);
            } else {
                pgTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this._pgNameToOid.put(schema + "." + name, oid);
                }
            }
            this._pgNameToOid.put(pgTypeName, oid);
            this._oidToPgName.put(oid, pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    @Override
    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        int pgType = 0;
        for (String newTypeName : new String[]{TypeInfoCache.combainStringIfOneQuoted("_", elementTypeName), TypeInfoCache.combainStringIfOneQuoted(elementTypeName, "[]")}) {
            pgType = this.getPGType(newTypeName);
            if (pgType == 0) continue;
            return pgType;
        }
        return pgType;
    }

    private static String combainStringIfOneQuoted(String first, String second) {
        if (first.startsWith("\"")) {
            return first.substring(0, first.length() - 1) + second + "\"";
        }
        if (second.startsWith("\"")) {
            return "\"" + first + second.substring(1);
        }
        return first + second;
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this._pgArrayToPgType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this._arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this._getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayDelimiterStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this._arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = this._pgArrayToPgType.get(oid);
        if (pgType != null) {
            return pgType;
        }
        if (this._getArrayElementOidStatement == null) {
            int workingVersionNum = Integer.parseInt(this._conn.getQueryExecutor().getWorkingVersionNum());
            String sql = workingVersionNum < 92820 ? "SELECT e.oid, n.nspname = ANY(pg_catalog.current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?" : "SELECT t.oid,n.nspname = ANY(pg_catalog.current_schemas(TRUE)),n.nspname,t.typname FROM pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = (SELECT CASE WHEN a.typtype = 'o' AND (SELECT c.typinput !='array_in'::regproc FROM pg_type c WHERE c.oid = a.typelem and c.typtype!='o') THEN ( SELECT b.typarray FROM pg_type b WHERE b.oid = a.typelem) ELSE a.typelem END AS res FROM pg_type a WHERE a.oid = ? );";
            this._getArrayElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("NO_DATA_RETURNED", new Object[0]), PSQLState.NO_DATA);
        }
        pgType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this._pgArrayToPgType.put(oid, pgType);
        this._pgNameToOid.put(schema + "." + name, pgType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this._pgNameToOid.put(fullName, pgType);
        if (onPath && name.equals(name.toLowerCase())) {
            this._oidToPgName.put(pgType, name);
            this._pgNameToOid.put(name, pgType);
        } else {
            this._oidToPgName.put(pgType, fullName);
        }
        rs.close();
        return pgType;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        return this._pgNameToPgObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        String result = this._pgNameToJavaClass.get(pgTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this._pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        return this._conn.getCompatibilityMode().getTypeInfoHandler().getPrecision(oid, typmod, this._unknownLength);
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        return this._conn.getCompatibilityMode().getTypeInfoHandler().getScale(oid, typmod);
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        return this._conn.getCompatibilityMode().getTypeInfoHandler().isCaseSensitive(oid);
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        return this._conn.getCompatibilityMode().getTypeInfoHandler().isSigned(oid);
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        return this._conn.getCompatibilityMode().getTypeInfoHandler().getDisplaySize(oid, typmod, this._unknownLength);
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: 
            case 9003: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    static {
        typeAliases.put("tinyint", "int1");
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
    }
}

