/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.hostchooser;

import com.huawei.gaussdb.jdbc.hostchooser.HostStatus;

public enum HostRequirement {
    any{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.ConnectFail;
        }
    }
    ,
    master{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Master || status == HostStatus.ConnectOK;
        }
    }
    ,
    secondary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Secondary || status == HostStatus.ConnectOK;
        }
    }
    ,
    preferSecondary{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.ConnectFail;
        }
    }
    ,
    clusterMainNode{

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.Master || status == HostStatus.MainStandby || status == HostStatus.ConnectOK;
        }
    };


    public abstract boolean allowConnectingTo(HostStatus var1);

    public static HostRequirement getTargetServerType(String targetServerType) {
        String allowSlave = targetServerType.replace("lave", "econdary");
        return HostRequirement.valueOf(allowSlave);
    }
}

