/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.websocket.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.plugin.websocket.collector.WebsocketCollector;
import com.lubanops.apm.plugin.websocket.interceptor.Utils;
import jakarta.websocket.CloseReason;
import org.apache.tomcat.websocket.WsSession;

public class DoCloseInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (WebsocketCollector.INSTANCE.isEnable()) {
            WebsocketCollector.exception(e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        WsSession session;
        if (WebsocketCollector.INSTANCE.isEnable() && (session = (WsSession)object) != null) {
            String closeReason = "";
            if (args[0] != null) {
                if ("javax.websocket.CloseReason".equals(args[0].getClass().getName())) {
                    closeReason = ((javax.websocket.CloseReason)args[0]).getReasonPhrase();
                } else if ("jakarta.websocket.CloseReason".equals(args[0].getClass().getName())) {
                    closeReason = ((CloseReason)args[0]).getReasonPhrase();
                }
                WebsocketCollector.closeSession(Utils.getRestUrl(session), closeReason);
            }
        }
    }
}

