/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.mongodb.MongoStatsConfig;
import com.lubanops.apm.plugin.mongodb.stats.MongoClientStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MongoClientAggregator
extends MultiPrimaryKeyAggregator<MongoClientStats> {
    private static final String NAMESPACE = "namespace";
    private static final String COMMAND = "command";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<MongoClientStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();
    private static final String MONGO_PARSE_ORIGINAL_COMMAND = "MongoParseOriginalCommand";

    public void parseParameters(Map<String, String> parameters) {
        Boolean isParseOriginalCommand = ParameterParseUtil.getBoolean(parameters, (String)MONGO_PARSE_ORIGINAL_COMMAND);
        if (isParseOriginalCommand != null) {
            MongoStatsConfig.setIsParseOriginalCommand(isParseOriginalCommand);
        }
    }

    public void incrementQueryCount(long count) {
        if (!this.isEnable) {
            return;
        }
        MongoClientStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementQueryCount(count);
        }
    }

    public void incrementUpdateCount(long count) {
        if (!this.isEnable) {
            return;
        }
        MongoClientStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementUpdateCount(count);
        }
    }

    public void onStart(String namespace, String command) {
        if (!this.isEnable) {
            return;
        }
        MongoClientStats stats = (MongoClientStats)this.getValue(new String[]{namespace, command});
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        MongoClientStats stats = this.statsLocal.get();
        if (stats != null) {
            this.errorLocal.set(Boolean.TRUE);
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        MongoClientStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
        this.errorLocal.remove();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalQueryCount = 0L;
        long totalUpdateCount = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long invokeCount = (Long)row.get((Object)"invokeCount");
                Long queryCount = (Long)row.get((Object)"queryCount");
                Long updateCount = (Long)row.get((Object)"updateCount");
                Long errorCount = (Long)row.get((Object)"errorCount");
                Long totalTime = (Long)row.get((Object)"totalTime");
                if (invokeCount == null) {
                    invokeCount = 0L;
                }
                if (queryCount == null) {
                    queryCount = 0L;
                }
                if (updateCount == null) {
                    updateCount = 0L;
                }
                if (errorCount == null) {
                    errorCount = 0L;
                }
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalInvokeCount += invokeCount.longValue();
                totalQueryCount += queryCount.longValue();
                totalUpdateCount += updateCount.longValue();
                totalErrorCount += errorCount.longValue();
                totalTotalTime += totalTime.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"invokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"queryCount", (Object)totalQueryCount);
        totalRow.put((Object)"updateCount", (Object)totalUpdateCount);
        totalRow.put((Object)"errorCount", (Object)totalErrorCount);
        totalRow.put((Object)"totalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected Class<MongoClientStats> getValueType() {
        return MongoClientStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(NAMESPACE, COMMAND);
    }

    public String getName() {
        return "client";
    }
}

