/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterObjectHolder {
    private static final ConcurrentHashMap<ClusterId, String> mongoClusterId2HostsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> hostToClusterHostsMap = new ConcurrentHashMap();
    private static AtomicInteger num;
    private static CopyOnWriteArrayList<Object> holder;

    public static Integer acquireNum() {
        return num.incrementAndGet();
    }

    public static boolean register(Object cluster) {
        if (holder.size() < 10) {
            holder.add(cluster);
            return true;
        }
        return false;
    }

    public static CopyOnWriteArrayList<Object> getClusterList() {
        return holder;
    }

    public static Integer getOrRegister(Object cluster) {
        Integer clusterId = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)cluster, (String)"clusterId");
        if (clusterId == null) {
            boolean registered = ClusterObjectHolder.register(cluster);
            clusterId = ClusterObjectHolder.acquireNum();
            if (registered) {
                TransformAccessUtils.saveToLopsAttributeMap((Object)cluster, (String)"clusterId", (Object)clusterId);
                Object[] attributes = ((AttributeAccess)cluster).getLopsFileds();
                ClusterId mongoClusterId = (ClusterId)attributes[0];
                ClusterSettings settings = (ClusterSettings)attributes[1];
                List hostList = settings.getHosts();
                String hosts = ClusterObjectHolder.concatenateHosts(hostList);
                for (ServerAddress host : hostList) {
                    hostToClusterHostsMap.put(host.toString(), hosts);
                }
                mongoClusterId2HostsMap.put(mongoClusterId, hosts);
            }
        }
        return clusterId;
    }

    public static String concatenateHosts(List<ServerAddress> hosts) {
        StringBuilder builder = new StringBuilder();
        for (ServerAddress address : hosts) {
            String host = address.toString();
            if (builder.length() == 0) {
                builder.append(host);
                continue;
            }
            builder.append(",").append(host);
        }
        return builder.toString();
    }

    public static String getHostsByMongoClusterId(ClusterId mongoClusterId) {
        if (mongoClusterId != null) {
            return mongoClusterId2HostsMap.get(mongoClusterId);
        }
        return null;
    }

    public static String getMongoClusterHostsByHost(String host) {
        return hostToClusterHostsMap.get(host);
    }

    static {
        try {
            MongoDbCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)MongoClient.class.getProtectionDomain()));
        }
        catch (NoClassDefFoundError e) {
            try {
                MongoDbCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)Mongo.class.getProtectionDomain()));
            }
            catch (NoClassDefFoundError e2) {
                LogFactory.getLogger().log(Level.SEVERE, "Unknown Mongo version", (Throwable)e2);
                MongoDbCollector.setDriverVersion("unknown");
            }
        }
        num = new AtomicInteger(0);
        holder = new CopyOnWriteArrayList();
    }
}

