/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.http;

import com.huawei.shade.com.cloud.sdk.ClientConfiguration;
import com.huawei.shade.com.cloud.sdk.ClientException;
import com.huawei.shade.com.cloud.sdk.Request;
import com.huawei.shade.com.cloud.sdk.RequestClientOptions;
import com.huawei.shade.com.cloud.sdk.Response;
import com.huawei.shade.com.cloud.sdk.WebServiceRequest;
import com.huawei.shade.com.cloud.sdk.WebServiceResponse;
import com.huawei.shade.com.cloud.sdk.auth.credentials.Credentials;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.http.ExecutionContext;
import com.huawei.shade.com.cloud.sdk.http.HttpClientFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpRequestFactory;
import com.huawei.shade.com.cloud.sdk.http.HttpResponse;
import com.huawei.shade.com.cloud.sdk.http.HttpResponseHandler;
import com.huawei.shade.com.cloud.sdk.http.RequestHandler;
import com.huawei.shade.com.cloud.sdk.util.IOUtils;
import com.huawei.shade.org.apache.commons.logging.Log;
import com.huawei.shade.org.apache.commons.logging.LogFactory;
import com.huawei.shade.org.apache.http.Header;
import com.huawei.shade.org.apache.http.annotation.ThreadSafe;
import com.huawei.shade.org.apache.http.client.HttpClient;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.client.methods.HttpUriRequest;
import com.huawei.shade.org.apache.http.protocol.BasicHttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class InnerHttpClient {
    private static final Log requestLog;
    private static final Log log;
    private static final HttpRequestFactory httpRequestFactory;
    private static final HttpClientFactory httpClientFactory;
    private final HttpClient httpClient;
    private final ClientConfiguration config;

    public InnerHttpClient(ClientConfiguration config) {
        this(config, httpClientFactory.createHttpClient(config));
    }

    InnerHttpClient(ClientConfiguration config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
    }

    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<WebServiceResponse<T>> responseHandler, ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new ClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler> requestHandlers = this.requestHandler2s(request, executionContext);
        WebServiceRequest req = request.getOriginalRequest();
        Map<String, String> customHeaders = req.getCustomRequestHeaders();
        if (customHeaders != null) {
            request.getHeaders().putAll(customHeaders);
        }
        Response<T> response = null;
        InputStream origContent = request.getContent();
        try {
            response = this.executeHelper(request, responseHandler, executionContext);
            this.afterResponse(request, requestHandlers, response);
            Response<T> response2 = response;
            return response2;
        }
        catch (ClientException e) {
            this.afterError(request, response, requestHandlers, e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly(origContent, log);
        }
    }

    private <T> void afterResponse(Request<?> request, List<RequestHandler> requestHandlers, Response<T> response) {
        for (RequestHandler handler : requestHandlers) {
            if (null == handler) continue;
            handler.afterResponse(request, response);
        }
    }

    private void afterError(Request<?> request, Response<?> response, List<RequestHandler> requestHandlers, ClientException e) {
        for (RequestHandler handler : requestHandlers) {
            if (null == handler) continue;
            handler.afterError(request, response, e);
        }
    }

    private List<RequestHandler> requestHandler2s(Request<?> request, ExecutionContext executionContext) {
        List<RequestHandler> requestHandlers = executionContext.getRequestHandlers();
        if (null == requestHandlers) {
            return Collections.emptyList();
        }
        for (RequestHandler requestHandler : requestHandlers) {
            if (null == requestHandler) continue;
            requestHandler.beforeRequest(request);
        }
        return requestHandlers;
    }

    private <T> Response<T> executeHelper(Request<?> request, HttpResponseHandler<WebServiceResponse<T>> responseHandler, ExecutionContext executionContext) {
        this.setUserAgent(request);
        ExecOneRequestParams p = new ExecOneRequestParams();
        try {
            return this.executeOneRequest(request, responseHandler, executionContext, p);
        }
        catch (IOException ioe) {
            if (log.isInfoEnabled()) {
                log.info("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
            }
            return null;
        }
    }

    private <T> Response<T> executeOneRequest(Request<?> request, HttpResponseHandler<WebServiceResponse<T>> responseHandler, ExecutionContext execContext, ExecOneRequestParams p) throws IOException {
        if (requestLog.isDebugEnabled()) {
            requestLog.debug("Sending Request: " + request);
        }
        Credentials credentials = execContext.getCredentials();
        p.newSigner(execContext);
        if (p.signer != null && credentials != null) {
            p.signer.sign(request, credentials);
        }
        p.newApacheRequest(httpRequestFactory, request, this.config, execContext);
        BasicHttpContext httpContext = new BasicHttpContext();
        p.apacheResponse = this.httpClient.execute((HttpUriRequest)p.apacheRequest, httpContext);
        HttpResponse httpResponse = this.createResponse(p.apacheRequest, request, p.apacheResponse);
        T response = this.handleResponse(responseHandler, httpResponse);
        return new Response<T>(response, httpResponse);
    }

    private void setUserAgent(Request<?> request) {
        String userAgentMarker;
        WebServiceRequest req;
        RequestClientOptions opts;
        String userAgent = this.config.getUserAgent();
        if (userAgent == null) {
            return;
        }
        request.addHeader("User-Agent", userAgent);
        if (!userAgent.equals("Apache HTTPClient")) {
            userAgent = userAgent + ", Apache HTTPClient";
        }
        if ((opts = (req = request.getOriginalRequest()).getRequestClientOptions()) != null && (userAgentMarker = opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            request.addHeader("User-Agent", InnerHttpClient.createUserAgentString(userAgent, userAgentMarker));
        }
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString.trim() + " " + userAgent.trim();
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private <T> T handleResponse(HttpResponseHandler<WebServiceResponse<T>> responseHandler, HttpResponse httpResponse) throws IOException {
        try {
            WebServiceResponse<T> response = responseHandler.handle(httpResponse);
            return response.getResult();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "). Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText();
            throw new ClientException(errorMessage, e);
        }
    }

    private HttpResponse createResponse(HttpRequestBase apacheHttpRequest, Request<?> request, com.huawei.shade.org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, apacheHttpRequest);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    static {
        String jvmVersion;
        requestLog = LogFactory.getLog("Request");
        log = LogFactory.getLog(InnerHttpClient.class);
        httpRequestFactory = new HttpRequestFactory();
        httpClientFactory = new HttpClientFactory();
        List<String> problematicJvmVersions = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17", "1.6.0_65", "1.7.0_45");
        if (problematicJvmVersions.contains(jvmVersion = System.getProperty("java.version"))) {
            log.warn("Detected a possible problem with the current JVM version (" + jvmVersion + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update.");
        }
    }

    private static class ExecOneRequestParams {
        private Signer signer;
        HttpRequestBase apacheRequest;
        com.huawei.shade.org.apache.http.HttpResponse apacheResponse;

        private ExecOneRequestParams() {
        }

        Signer newSigner(ExecutionContext execContext) {
            this.signer = execContext.getSigner();
            return this.signer;
        }

        HttpRequestBase newApacheRequest(HttpRequestFactory httpRequestFactory, Request<?> request, ClientConfiguration config, ExecutionContext execContext) {
            this.apacheRequest = httpRequestFactory.createHttpRequest(request, config, execContext);
            return this.apacheRequest;
        }
    }
}

