/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.http;

import com.huawei.shade.com.cloud.sdk.ClientConfiguration;
import com.huawei.shade.com.cloud.sdk.ClientException;
import com.huawei.shade.com.cloud.sdk.Request;
import com.huawei.shade.com.cloud.sdk.http.ExecutionContext;
import com.huawei.shade.com.cloud.sdk.http.HttpMethodName;
import com.huawei.shade.com.cloud.sdk.http.RepeatableInputStreamRequestEntity;
import com.huawei.shade.com.cloud.sdk.util.HttpUtils;
import com.huawei.shade.org.apache.http.HttpEntity;
import com.huawei.shade.org.apache.http.client.config.RequestConfig;
import com.huawei.shade.org.apache.http.client.methods.HttpDelete;
import com.huawei.shade.org.apache.http.client.methods.HttpGet;
import com.huawei.shade.org.apache.http.client.methods.HttpHead;
import com.huawei.shade.org.apache.http.client.methods.HttpPatch;
import com.huawei.shade.org.apache.http.client.methods.HttpPost;
import com.huawei.shade.org.apache.http.client.methods.HttpPut;
import com.huawei.shade.org.apache.http.client.methods.HttpRequestBase;
import com.huawei.shade.org.apache.http.entity.BufferedHttpEntity;
import com.huawei.shade.org.apache.http.entity.StringEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;

class HttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";

    HttpRequestFactory() {
    }

    HttpRequestBase createHttpRequest(Request<?> request, ClientConfiguration clientConfiguration, ExecutionContext context) {
        HttpRequestBase httpRequest;
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        boolean requestHasNoPayload = request.getContent() != null;
        boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        if (request.getHttpMethod() == HttpMethodName.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() == null && encodedParams != null) {
                postMethod.setEntity(this.newStringEntity(encodedParams));
            } else {
                postMethod.setEntity(new RepeatableInputStreamRequestEntity(request));
            }
            httpRequest = postMethod;
        } else if (request.getHttpMethod() == HttpMethodName.PUT) {
            HttpPut putMethod;
            httpRequest = putMethod = new HttpPut(uri);
            putMethod.setConfig(RequestConfig.custom().setExpectContinueEnabled(true).build());
            if (request.getContent() != null) {
                HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    entity = this.newBufferedHttpEntity(entity);
                }
                putMethod.setEntity(entity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.PATCH) {
            HttpPatch patchMethod = new HttpPatch(uri);
            httpRequest = patchMethod;
            if (request.getContent() != null) {
                HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
                if (request.getHeaders().get("Content-Length") == null) {
                    entity = this.newBufferedHttpEntity(entity);
                }
                patchMethod.setEntity(entity);
            }
        } else if (request.getHttpMethod() == HttpMethodName.GET) {
            httpRequest = new HttpGet(uri);
        } else if (request.getHttpMethod() == HttpMethodName.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (request.getHttpMethod() == HttpMethodName.HEAD) {
            httpRequest = new HttpHead(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
        }
        this.configureHeaders(httpRequest, request, context, clientConfiguration);
        return httpRequest;
    }

    private void configureHeaders(HttpRequestBase httpRequest, Request<?> request, ExecutionContext context, ClientConfiguration clientConfiguration) {
        URI endpoint = request.getEndpoint();
        String hostHeader = endpoint.getHost();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        httpRequest.addHeader("Host", hostHeader);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
        if (context != null && context.getContextUserAgent() != null) {
            httpRequest.addHeader("User-Agent", this.createUserAgentString(clientConfiguration, context.getContextUserAgent()));
        }
    }

    private String createUserAgentString(ClientConfiguration clientConfiguration, String contextUserAgent) {
        if (clientConfiguration.getUserAgent().contains(contextUserAgent)) {
            return clientConfiguration.getUserAgent();
        }
        return clientConfiguration.getUserAgent() + " " + contextUserAgent;
    }

    private HttpEntity newStringEntity(String s) {
        try {
            return new StringEntity(s);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }

    private HttpEntity newBufferedHttpEntity(HttpEntity entity) {
        try {
            return new BufferedHttpEntity(entity);
        }
        catch (IOException e) {
            throw new ClientException("Unable to create HTTP entity: " + e.getMessage(), e);
        }
    }
}

