/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.auth.signer;

import com.huawei.shade.com.cloud.sdk.auth.signer.DefaultSigner;
import com.huawei.shade.com.cloud.sdk.auth.signer.RegionSigner;
import com.huawei.shade.com.cloud.sdk.auth.signer.ServiceSigner;
import com.huawei.shade.com.cloud.sdk.auth.signer.Signer;
import com.huawei.shade.com.cloud.sdk.internal.config.InternalConfig;
import com.huawei.shade.com.cloud.sdk.internal.config.SignerConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SignerFactory {
    private static final String DEFAULT_SIGNER = "DefaultSignerType";
    private static final Map<String, Class<? extends Signer>> SIGNERS = new ConcurrentHashMap<String, Class<? extends Signer>>();

    private SignerFactory() {
    }

    public static void registerSigner(String signerType, Class<? extends Signer> signerClass) {
        if (signerType == null) {
            throw new IllegalArgumentException("signerType cannot be null");
        }
        if (signerClass == null) {
            throw new IllegalArgumentException("signerClass cannot be null");
        }
        SIGNERS.put(signerType, signerClass);
    }

    public static Signer getSigner(String serviceName, String regionName) {
        return SignerFactory.lookupAndCreateSigner(serviceName, regionName);
    }

    public static Signer getSignerByTypeAndService(String signerType, String serviceName) {
        return SignerFactory.createSigner(signerType, serviceName, null);
    }

    private static Signer lookupAndCreateSigner(String serviceName, String regionName) {
        InternalConfig config = InternalConfig.Factory.getInternalConfig();
        SignerConfig signerConfig = config.getSignerConfig(serviceName, regionName);
        String signerType = signerConfig.getSignerType();
        return SignerFactory.createSigner(signerType, serviceName, regionName);
    }

    private static Signer createSigner(String signerType, String serviceName, String regionName) {
        Signer signer;
        Class<? extends Signer> signerClass = SIGNERS.get(signerType);
        if (signerClass == null) {
            throw new IllegalArgumentException("unknown signer type: " + signerType);
        }
        try {
            signer = signerClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot create an instance of " + signerClass.getName(), ex);
        }
        if (signer instanceof ServiceSigner) {
            ((ServiceSigner)signer).setServiceName(serviceName);
        }
        if (signer instanceof RegionSigner) {
            ((RegionSigner)signer).setRegionName(regionName);
        }
        return signer;
    }

    static {
        SIGNERS.put(DEFAULT_SIGNER, DefaultSigner.class);
    }
}

