/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.httpasyncclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.httpasyncclient.collector.ApacheHttpAsyncClientCollector;
import com.lubanops.apm.plugin.httpasyncclient.collector.NioConnectionStats;
import java.util.Map;
import org.apache.http.nio.reactor.SessionRequest;

public class SessionRequestCallbackInterceptor
implements Interceptor {
    private static final String STATUS = "Status";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            SessionRequest sessionRequest;
            Map map;
            if (ApacheHttpAsyncClientCollector.INSTANCE.isEnable() && (map = (Map)((TransformAccess)(sessionRequest = (SessionRequest)args[0])).getLopsAttribute()) != null) {
                Long startTime = (Long)map.get("startTime");
                NioConnectionStats stats = (NioConnectionStats)((Object)map.get("stats"));
                SpanEvent spanEvent = (SpanEvent)map.get("spanEvent");
                String status = "Unknown.";
                boolean isError = false;
                if (methodName.equals("completed")) {
                    status = "Completed.";
                } else if (methodName.equals("failed")) {
                    status = "Failed.";
                    isError = true;
                } else if (methodName.equals("cancel")) {
                    status = "Canceled.";
                } else if (methodName.equals("timeout")) {
                    status = "Timeout.";
                }
                if (spanEvent != null) {
                    spanEvent.addTag(STATUS, status);
                    if (isError) {
                        spanEvent.setSpanError(true);
                        ApacheHttpAsyncClientCollector.INSTANCE.onError(stats);
                    }
                    spanEvent.setTimeUsed(System.nanoTime() - spanEvent.getStartNanoTime());
                    if (spanEvent.getTimeUsed() >= (long)ApacheHttpAsyncClientCollector.INSTANCE.getTimeSpanThreshold()) {
                        TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                    }
                }
                ApacheHttpAsyncClientCollector.INSTANCE.onFinally(startTime, stats);
            }
        }
        catch (Exception sessionSetStatusException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)sessionSetStatusException);
        }
    }
}

