/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.reactornetty.server.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.url.collector.RequestContext;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlAnalysisUtils;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlSampleFilter;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.WebContainerType;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpServerState;

public class HttpServerHandleInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (UrlStatsCollector.INSTANCE.isEnable() && args[1] instanceof ConnectionObserver.State && args[0] instanceof HttpServerRequest && args[0] instanceof HttpServerResponse) {
            Object context;
            HttpServerRequest httpServerRequest = (HttpServerRequest)args[0];
            HttpHeaders headers = httpServerRequest.requestHeaders();
            HttpServerResponse httpServerResponse = (HttpServerResponse)args[0];
            ConnectionObserver.State state = (ConnectionObserver.State)args[1];
            if (this.isRequestStart(state)) {
                this.requestStart(headers, httpServerRequest, httpServerResponse, className, methodName, args);
            } else if ((state == ConnectionObserver.State.DISCONNECTING || state == ConnectionObserver.State.RELEASED) && args[0] instanceof TransformAccess && (context = ((TransformAccess)args[0]).getLopsAttribute()) != null && context instanceof RequestContext) {
                SpanEvent spanEvent = ((RequestContext)context).getSpanEvent();
                Map map = ((RequestContext)context).getMap();
                List txName = ((RequestContext)context).getTxName();
                ((TransformAccess)args[0]).setLopsAttribute(null);
                TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                TransactionCollector.setTxName((List)txName);
                UrlStatsCollector.setThreadLocalMap((Map)map);
                String envId = headers.get(Headers.ENV_ID.getValue());
                int code = httpServerResponse.status().code();
                Boolean hasException = TraceCollector.hasException();
                String exceptionType = TraceCollector.getExceptionType();
                boolean hasError = UrlStatsCollector.onFinally((int)code, (String)envId, (String)httpServerRequest.uri(), (boolean)hasException, (String)exceptionType);
                TraceCollector.onFinally((int)code, (boolean)hasError);
            }
        }
        return null;
    }

    private void requestStart(HttpHeaders headers, HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse, String className, String methodName, Object[] args) {
        String realUrl;
        String domainId = headers.get(Headers.DOMAIN_ID.getValue());
        String domainType = headers.get(Headers.DOMAIN_TYPE.getValue());
        String traceId = headers.get(Headers.TRACE_ID.getValue());
        String spanId = headers.get(Headers.SPAN_ID.getValue());
        String sourceEventId = headers.get(Headers.SOURCE_EVENT_ID.getValue());
        String gtraceId = headers.get(Headers.GTRACE_ID.getValue());
        String txName = headers.get(Headers.TXNANE_ID.getValue());
        String userFlag = headers.get(Headers.USER_FLAG.getValue());
        String policyId = headers.get(Headers.POLICY_ID.getValue());
        String envId = headers.get(Headers.ENV_ID.getValue());
        String otelHeader = headers.get(Headers.OTEL_HEADER.getValue());
        String method = httpServerRequest.method().name();
        String url = realUrl = httpServerRequest.uri();
        int index = realUrl.indexOf("?");
        if (index > 0) {
            url = realUrl.substring(0, index);
        }
        String targetUrl = UrlAnalysisUtils.getTargetUrl((String)url, null, null);
        if (AgentConfigManager.isTxEnable()) {
            TransactionCollector.generateTxList((String)txName, (String)targetUrl, (String)method);
        }
        if (targetUrl != null) {
            UrlStatsCollector.onStart((String)targetUrl, (String)method, (String)envId);
            StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
            startTraceRequest.setKind(WebContainerType.ReactorNetty.toString());
            startTraceRequest.setSource(targetUrl);
            startTraceRequest.setRealSource(realUrl);
            startTraceRequest.setHttpMethod(method);
            startTraceRequest.setSourceEventId(sourceEventId);
            startTraceRequest.setDomainId(domainId);
            startTraceRequest.setDomainType(domainType);
            startTraceRequest.setPolicyId(policyId);
            startTraceRequest.setSampleFilter((SampleFilter)new UrlSampleFilter());
            startTraceRequest.setOtelTraceParent(otelHeader);
            SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
            HttpServerHandleInterceptor.updateSpanEvent(spanEvent, httpServerRequest, httpServerResponse, headers);
        }
        if (TraceCollector.isSameDomain((String)domainId, (String)domainType)) {
            httpServerResponse.header((CharSequence)Headers.ENV_ID.getValue(), (CharSequence)String.valueOf(IdentityConfigManager.getEnvId()));
        }
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        Map map = UrlStatsCollector.getThreadLocalMap();
        List txNameList = TransactionCollector.getTxName();
        if (args[0] instanceof TransformAccess) {
            RequestContext requestContext = new RequestContext();
            requestContext.setSpanEvent(spanEvent);
            requestContext.setgTraceId(TraceCollector.getVirtualTraceId());
            requestContext.setUserFlag(userFlag);
            requestContext.setPolicyId(policyId);
            requestContext.setMap(map);
            requestContext.setTxName(txNameList);
            ((TransformAccess)args[0]).setLopsAttribute((Object)requestContext);
        }
    }

    private static void updateSpanEvent(SpanEvent spanEvent, HttpServerRequest request, HttpServerResponse response, HttpHeaders headers) {
        if (spanEvent != null) {
            String[] paramKeys;
            String[] headKeys;
            String remoteAddr = request.remoteAddress().toString();
            TraceCollector.addTag((String)"remoteAddr", (String)remoteAddr);
            for (String headKey : headKeys = UrlStatsConfig.getHeaderKeys()) {
                String value = headers.get(headKey);
                TraceCollector.addTag((String)headKey, (String)value);
            }
            for (String paramKey : paramKeys = UrlStatsConfig.getParameterKeys()) {
                String value = request.param((CharSequence)paramKey);
                TraceCollector.addTag((String)paramKey, (String)value);
            }
            HttpServerHandleInterceptor.renderCookie(request);
            response.header((CharSequence)Headers.TRACE_ID.getValue(), (CharSequence)spanEvent.getTraceId());
            response.header((CharSequence)Headers.SPAN_ID.getValue(), (CharSequence)spanEvent.getSpanId());
            response.header((CharSequence)Headers.GTRACE_ID.getValue(), (CharSequence)spanEvent.getGlobalTraceId());
        }
    }

    private static void renderCookie(HttpServerRequest request) {
        String[] cookieKeys = UrlStatsConfig.getCookieKeys();
        Map cookiesMap = request.cookies();
        if (cookiesMap != null) {
            for (String cookieKey : cookieKeys) {
                String cookieValue = null;
                block1: for (Set cookies : cookiesMap.values()) {
                    for (Cookie cookie : cookies) {
                        if (!cookie.name().equalsIgnoreCase(cookieKey)) continue;
                        cookieValue = cookie.value();
                        continue block1;
                    }
                }
                if (cookieValue == null) continue;
                TraceCollector.addTag((String)cookieKey, cookieValue);
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        TraceCollector.clear();
        UrlStatsCollector.clearThreadLocal();
        TransactionCollector.clear();
    }

    private boolean isRequestStart(ConnectionObserver.State state) {
        try {
            Class.forName("reactor.netty.http.server.HttpServerState");
            return state == HttpServerState.REQUEST_RECEIVED;
        }
        catch (ClassNotFoundException e) {
            return state == ConnectionObserver.State.CONFIGURED;
        }
    }
}

