/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith.interceptor.gaussjdbc200;

import com.huawei.gauss200.jdbc.jdbc.PgConnection;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.gaussdb.zenith.GaussUtils;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbCollector;
import java.security.ProtectionDomain;

public class Gauss200ConnectionInterceptor
implements Interceptor {
    public Gauss200ConnectionInterceptor() {
        GaussDbCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)PgConnection.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            PgConnection connection = (PgConnection)object;
            String pgDbName = Helper.getDbName((String)GaussUtils.getHostPostPair(connection.getQueryExecutor().getHostSpec()), (String)connection.getCatalog());
            Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(pgDbName);
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setLopsAttribute((Object)id);
            }
            GaussDbCollector.onConnectionCreated(id);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.INFO, "", (Throwable)ex);
        }
    }
}

