/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.collector;

import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.common.DefaultServerNodeAggregator;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.hbase.HBaseContext;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.ClusterConnection;

public class HBaseServerNodeAggregator
extends DefaultServerNodeAggregator {
    public Map<String, Object> onFinally() {
        Map res = super.onFinally();
        Long timeUsed = (Long)res.get("serverAddrTimeUsed");
        Boolean hasError = (Boolean)res.get("serverAddrErr");
        if (hasError == null) {
            hasError = Boolean.FALSE;
        }
        if (timeUsed != null) {
            ClusterConnection connection = HBaseContext.CONNECTION_LOCAL.get();
            String clusterId = HBaseUtils.getClusterIdFromConnection(connection);
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)("HBase:" + clusterId), (List)TransactionCollector.getTxName(), (String)"HBase");
        }
        return res;
    }
}

