/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.mqtt.stats.MqttPublishStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MqttClientPublishAggregator
extends MultiPrimaryKeyAggregator<MqttPublishStats> {
    private static final String CLIENT_ID = "clientId";
    private static final String TOPIC = "topic";

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onSendPublishMsg(String clientId, String topic, int bytesCount) {
        MqttPublishStats stats = (MqttPublishStats)this.getValue(new String[]{clientId, topic});
        stats.onSendMsg(bytesCount);
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalMsgSentCount = 0L;
        long totalBytesSent = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long msgSentCount = (Long)row.get((Object)"msgSentCount");
                Long bytesSent = (Long)row.get((Object)"bytesSent");
                if (msgSentCount == null) {
                    msgSentCount = 0L;
                }
                if (bytesSent == null) {
                    bytesSent = 0L;
                }
                totalMsgSentCount += msgSentCount.longValue();
                totalBytesSent += bytesSent.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"msgSentCount", (Object)totalMsgSentCount);
        totalRow.put((Object)"bytesSent", (Object)totalBytesSent);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected Class<MqttPublishStats> getValueType() {
        return MqttPublishStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(CLIENT_ID, TOPIC);
    }

    public String getName() {
        return "clientPublish";
    }
}

