/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.tunnel.client.ForwardClientSocketClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardClient {
    private static final Logger logger = LoggerFactory.getLogger(ForwardClient.class);
    private URI tunnelServerURI;

    public ForwardClient(URI tunnelServerURI) {
        this.tunnelServerURI = tunnelServerURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws URISyntaxException, SSLException, InterruptedException {
        block6: {
            NioEventLoopGroup group;
            block5: {
                String host;
                String scheme = this.tunnelServerURI.getScheme() == null ? "ws" : this.tunnelServerURI.getScheme();
                String string = host = this.tunnelServerURI.getHost() == null ? "127.0.0.1" : this.tunnelServerURI.getHost();
                final int port = this.tunnelServerURI.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : this.tunnelServerURI.getPort();
                if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                    logger.error("Only WS(S) is supported, uri: {}", (Object)this.tunnelServerURI);
                    return;
                }
                boolean ssl = "wss".equalsIgnoreCase(scheme);
                final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
                WebSocketClientProtocolConfig clientProtocolConfig = WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.tunnelServerURI).maxFramePayloadLength(0xA00000).build();
                final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(clientProtocolConfig);
                final ForwardClientSocketClientHandler forwardClientSocketClientHandler = new ForwardClientSocketClientHandler();
                group = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("arthas-ForwardClient", true));
                ChannelFuture closeFuture = null;
                try {
                    Bootstrap b = new Bootstrap();
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
                    ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                        protected void initChannel(SocketChannel ch) {
                            ChannelPipeline p = ch.pipeline();
                            if (sslCtx != null) {
                                p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                            }
                            p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(0xA00000), websocketClientHandler, forwardClientSocketClientHandler});
                        }
                    });
                    closeFuture = b.connect(this.tunnelServerURI.getHost(), port).sync().channel().closeFuture();
                    logger.info("forward client connect to server success, uri: " + this.tunnelServerURI);
                    if (closeFuture == null) break block5;
                }
                catch (Throwable throwable) {
                    if (closeFuture != null) {
                        closeFuture.addListener((GenericFutureListener)new ChannelFutureListener((EventLoopGroup)group){
                            final /* synthetic */ EventLoopGroup val$group;
                            {
                                this.val$group = eventLoopGroup;
                            }

                            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                                this.val$group.shutdownGracefully();
                            }
                        });
                    } else {
                        group.shutdownGracefully();
                    }
                    throw throwable;
                }
                closeFuture.addListener((GenericFutureListener)new /* invalid duplicate definition of identical inner class */);
                break block6;
            }
            group.shutdownGracefully();
        }
    }
}

