/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.consumer.stats.RocketMqConsumeStats;
import java.util.List;

public abstract class RocketMqBasicConsumeAggregator
extends MultiPrimaryKeyAggregator<RocketMqConsumeStats> {
    protected final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    protected final ThreadLocal<RocketMqConsumeStats> statsLocal = new ThreadLocal();

    public void incrementConsumedMsgCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedMsgCount(count);
        }
    }

    public void incrementConsumedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementConsumedBytesCount(count);
        }
    }

    public void incrementReconsumeTimes(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementReconsumeTimes(count);
        }
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RocketMqConsumeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    protected abstract List<String> primaryKey();

    public abstract String getName();
}

