/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.apm;

import com.lubanops.apm.bootstrap.api.HarvestListener;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSet;
import com.lubanops.apm.bootstrap.plugin.apm.DetailAggregator;
import com.lubanops.apm.bootstrap.plugin.apm.ExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.apm.RepositoryAggregator;
import com.lubanops.apm.bootstrap.plugin.apm.TransferAggregator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class APMCollector
extends Collector {
    public static final String COLLECTOR_APM = "ProbeInfo";
    public static final APMCollector INSTANCE = new APMCollector();
    public static final DetailAggregator DETAIL_AGGREGATOR = new DetailAggregator();
    public static final ExceptionAggregator EXCEPTION_AGGREGATOR = new ExceptionAggregator();
    public static final TransferAggregator TRANSFER_AGGREGATOR = new TransferAggregator();
    public static final RepositoryAggregator REPOSITORY_AGGREGATOR = new RepositoryAggregator();
    private List<HarvestListener> harvestListeners = new ArrayList<HarvestListener>();

    public static void init() {
        CollectorManager.TAGS.add(COLLECTOR_APM);
    }

    public static void onStart(String type, int queueSize) {
        DETAIL_AGGREGATOR.onStart(type, queueSize);
    }

    public static void onDiscard(String type, long bytes) {
        DETAIL_AGGREGATOR.onDiscard(type, bytes);
    }

    public static void onThrowable(String type, long bytes, Throwable t) {
        DETAIL_AGGREGATOR.onThrowable(type, bytes);
        EXCEPTION_AGGREGATOR.onThrowable(type, t);
    }

    public static void onFinally(String type, long useTime) {
        DETAIL_AGGREGATOR.onFinally(type, useTime);
    }

    public static void onSuccess(String dataType, long bytes) {
        DETAIL_AGGREGATOR.onSuccess(dataType, bytes);
    }

    @Override
    public List<MetricSet> harvest() {
        for (HarvestListener listener : this.harvestListeners) {
            listener.onHarvest(this, System.currentTimeMillis());
        }
        return super.harvest();
    }

    @Override
    public void parseParameter(Map<String, String> parameters) {
    }

    @Override
    public String getCollectorName() {
        return COLLECTOR_APM;
    }

    public double successPercent(String type) {
        return DETAIL_AGGREGATOR.getSendSuccessPercent(type);
    }

    public double sendCount(String type) {
        return DETAIL_AGGREGATOR.getSendCount(type);
    }

    public double errorCount(String type) {
        return DETAIL_AGGREGATOR.getErrorCount(type);
    }

    public void listenHarvest(HarvestListener harvestListener) {
        this.harvestListeners.add(harvestListener);
    }

    public void monitorQueueSize(long monitorQueueSize, long monitorObjectSize) {
        REPOSITORY_AGGREGATOR.monitorQueueSize(monitorQueueSize, monitorObjectSize);
    }

    public void traceQueueSize(long traceQueueSize, long traceObjectSize) {
        REPOSITORY_AGGREGATOR.traceQueueSize(traceQueueSize, traceObjectSize);
    }

    static {
        INSTANCE.addModelAggregator(DETAIL_AGGREGATOR);
        INSTANCE.addModelAggregator(EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator(TRANSFER_AGGREGATOR);
        INSTANCE.addModelAggregator(REPOSITORY_AGGREGATOR);
        INSTANCE.register();
    }
}

