/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.command.model.ThreadModel;
import com.taobao.arthas.core.command.model.ThreadVO;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class ThreadModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    private static PDebuggerResponse.StackTraceElement toProtoStackTraceElement(StackTraceElement modelStackTraceElement) {
        String fileName = modelStackTraceElement.getFileName() != null ? modelStackTraceElement.getFileName() : "Unknown Source";
        return PDebuggerResponse.StackTraceElement.newBuilder().setClassName(modelStackTraceElement.getClassName()).setMethodName(modelStackTraceElement.getMethodName()).setLineNumber(modelStackTraceElement.getLineNumber()).setFileName(fileName).build();
    }

    private static PDebuggerResponse.ThreadInfo toProtoThreadInfo(ThreadInfo threadInfo) {
        StackTraceElement[] stackTrace;
        ArrayList<PDebuggerResponse.StackTraceElement> stackTraces = new ArrayList<PDebuggerResponse.StackTraceElement>();
        for (StackTraceElement stackTraceElement : stackTrace = threadInfo.getStackTrace()) {
            stackTraces.add(ThreadModelToPDebuggerResponseConverter.toProtoStackTraceElement(stackTraceElement));
        }
        List monitors = null;
        if (ObjectUtils.isNotEmpty((Object)threadInfo.getLockedMonitors())) {
            monitors = Arrays.stream(threadInfo.getLockedMonitors()).map(monitor -> PDebuggerResponse.MonitorInfo.newBuilder().setClassName(monitor.getClassName()).setStackFrame(ThreadModelToPDebuggerResponseConverter.toProtoStackTraceElement(monitor.getLockedStackFrame())).setStackDepth(monitor.getLockedStackDepth()).build()).collect(Collectors.toList());
        }
        PDebuggerResponse.ThreadInfo.Builder ThreadInfoBuilder = PDebuggerResponse.ThreadInfo.newBuilder().setThreadId(threadInfo.getThreadId()).setThreadName(threadInfo.getThreadName()).setBlockedCount(threadInfo.getBlockedCount()).setBlockedTime(threadInfo.getBlockedTime()).setWaitedCount(threadInfo.getWaitedCount()).setWaitedTime(threadInfo.getWaitedCount()).setInNative(threadInfo.isInNative()).setSuspended(threadInfo.isSuspended()).setLockOwnerId(threadInfo.getLockOwnerId()).addAllStackTrace(stackTraces).setThreadState(threadInfo.getThreadState().name());
        if (ObjectUtils.isNotEmpty(monitors)) {
            ThreadInfoBuilder.addAllLockedMonitors(monitors);
        }
        return ThreadInfoBuilder.build();
    }

    public static PDebuggerResponse convert(ResultModel resultModel, PDebuggerRequest request) {
        ThreadModel threadModel = (ThreadModel)resultModel;
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder();
        if (request.getPayload().getThreadCommand().getSingle()) {
            if (request.getPayload().getThreadCommand().getMostBlockingThread()) {
                PDebuggerResponse.ThreadInfo protoThreadInfo = ThreadModelToPDebuggerResponseConverter.toProtoThreadInfo(threadModel.getBlockingLockInfo().getThreadInfo());
                PDebuggerResponse.BlockingThreadResponse protoBlockingThread = PDebuggerResponse.BlockingThreadResponse.newBuilder().setThreadInfo(protoThreadInfo).setBlockedThreadsCount(threadModel.getBlockingLockInfo().getBlockingThreadCount()).build();
                payloadBuilder.setBlockingThreadResponse(protoBlockingThread);
            } else {
                PDebuggerResponse.ThreadInfo protoThreadInfo = ThreadModelToPDebuggerResponseConverter.toProtoThreadInfo(threadModel.getThreadInfo());
                PDebuggerResponse.SingleThreadResponse protoSingleThread = PDebuggerResponse.SingleThreadResponse.newBuilder().setThreadInfo(protoThreadInfo).build();
                payloadBuilder.setSingleThreadResponse(protoSingleThread).build();
            }
        } else {
            ArrayList<PDebuggerResponse.ThreadVO> threads = new ArrayList<PDebuggerResponse.ThreadVO>();
            for (ThreadVO threadStat : threadModel.getThreadStats()) {
                threads.add(ThreadModelToPDebuggerResponseConverter.ThreadVOToDebuggerResponseThreadVO(threadStat));
            }
            Map threadStateCount = threadModel.getThreadStateCount();
            PDebuggerResponse.ThreadListResponse threadListResponse = PDebuggerResponse.ThreadListResponse.newBuilder().setThreadStateCounters(PDebuggerResponse.ThreadStateCount.newBuilder().setNEW(threadStateCount.getOrDefault((Object)Thread.State.NEW, 0).intValue()).setBLOCKED(threadStateCount.getOrDefault((Object)Thread.State.BLOCKED, 0).intValue()).setRUNNABLE(threadStateCount.getOrDefault((Object)Thread.State.RUNNABLE, 0).intValue()).setTERMINATED(threadStateCount.getOrDefault((Object)Thread.State.TERMINATED, 0).intValue()).setWAITING(threadStateCount.getOrDefault((Object)Thread.State.WAITING, 0).intValue()).setTIMEDWAITING(threadStateCount.getOrDefault((Object)Thread.State.TIMED_WAITING, 0).intValue()).build()).addAllThreads(threads).build();
            payloadBuilder.setThreadListResponse(threadListResponse);
        }
        return ThreadModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static PDebuggerResponse.ThreadVO ThreadVOToDebuggerResponseThreadVO(ThreadVO threadStat) {
        if (threadStat.getId() == -1L) {
            return PDebuggerResponse.ThreadVO.newBuilder().setId(threadStat.getId()).setName(threadStat.getName()).setCpu(threadStat.getCpu()).setDeltaTime(threadStat.getDeltaTime()).setTime(threadStat.getTime()).setInterrupted(threadStat.isInterrupted()).setDaemon(threadStat.isDaemon()).build();
        }
        return PDebuggerResponse.ThreadVO.newBuilder().setId(threadStat.getId()).setGroup(threadStat.getGroup()).setName(threadStat.getName()).setPriority(threadStat.getPriority()).setState(threadStat.getState().toString()).setCpu(threadStat.getCpu()).setDeltaTime(threadStat.getDeltaTime()).setTime(threadStat.getTime()).setInterrupted(threadStat.isInterrupted()).setDaemon(threadStat.isDaemon()).build();
    }
}

