/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.outbound;

import com.lubanops.apm.integration.Constants;
import com.lubanops.apm.integration.access.Header;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.utils.JSON;

public class CollectorStatusRequest
extends MessageWrapper {
    private short type = (short)15;
    private CollectorStatusHeader header;
    private long messageId;

    public CollectorStatusRequest(Long instanceId, String collectorName, String metricSetName) {
        CollectorStatusHeader header = new CollectorStatusHeader();
        header.setCollectorName(collectorName);
        header.setInstanceId(instanceId);
        header.setMetricSetName(metricSetName);
        header.setNeedResponse(true);
        this.header = header;
        this.messageId = MessageIdGenerator.generateMessageId();
    }

    @Override
    public short getType() {
        return 15;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public String generateBodyString() {
        return "";
    }

    @Override
    public String getHeadString() {
        return JSON.toJSONString(this.header);
    }

    @Override
    public byte[] getHeaderBytes() {
        return this.header.toBytes();
    }

    @Override
    public String getBodyString() {
        throw new UnsupportedOperationException(CollectorStatusRequest.class.getSimpleName() + ".getBodyString() has no implementation.");
    }

    public static class CollectorStatusHeader
    extends Header {
        private Long instanceId;
        private String collectorName;
        private String metricSetName;

        public Long getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(Long instanceId) {
            this.instanceId = instanceId;
        }

        public String getCollectorName() {
            return this.collectorName;
        }

        public void setCollectorName(String collectorName) {
            this.collectorName = collectorName;
        }

        public String getMetricSetName() {
            return this.metricSetName;
        }

        public void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        public byte[] toBytes() {
            return JSON.toJSONString(this).getBytes(Constants.DEFAULT_CHARSET);
        }
    }
}

